/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class MultipleThreadFilterOneTest
extends ActiveMQTestBase {
    final String ADDRESS = "ADDRESS";
    final int numberOfMessages = 2000;
    final int nThreads = 4;
    private static final int PAGE_MAX = 102400;
    private static final int PAGE_SIZE = 10240;
    private boolean isNetty = false;

    @Test
    public void testSendingNetty() throws Exception {
        this.testSending(true, false);
    }

    @Test
    public void testSendingNettyPaging() throws Exception {
        this.testSending(true, true);
    }

    @Test
    public void testSendingInVM() throws Exception {
        this.testSending(false, false);
    }

    @Test
    public void testSendingInVMPaging() throws Exception {
        this.testSending(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSending(boolean isNetty, boolean isPaging) throws Exception {
        boolean useDeadConsumer = true;
        this.isNetty = isNetty;
        ActiveMQServer server = isPaging ? this.createServer(true, this.createDefaultConfig(isNetty), 10240, 102400L, new HashMap()) : this.createServer(true, isNetty);
        server.getConfiguration().setMessageExpiryScanPeriod(1000L);
        server.start();
        SomeConsumer[] consumers = new SomeConsumer[4];
        SomeProducer[] producers = new SomeProducer[4];
        SomeConsumer[] deadConsumers = null;
        try {
            int i;
            for (i = 0; i < 4; ++i) {
                consumers[i] = new SomeConsumer(i);
            }
            for (i = 0; i < 4; ++i) {
                producers[i] = new SomeProducer();
            }
            if (useDeadConsumer) {
                deadConsumers = new SomeConsumer[20];
                for (i = 0; i < 20; ++i) {
                    deadConsumers[i] = new SomeConsumer(i + 4);
                }
            }
            for (i = 0; i < 4; ++i) {
                consumers[i].start();
                producers[i].start();
            }
            for (SomeProducer someProducer : producers) {
                someProducer.join();
                Assert.assertEquals((long)0L, (long)someProducer.errors.get());
            }
            for (Thread thread : consumers) {
                thread.join();
                Assert.assertEquals((long)0L, (long)((SomeConsumer)thread).errors.get());
            }
            if (useDeadConsumer) {
                for (Thread thread : deadConsumers) {
                    ((SomeConsumer)thread).close();
                }
            }
            this.waitForNotPaging(server.locateQueue(new SimpleString("Q1")));
        }
        finally {
            server.stop();
        }
    }

    class SomeConsumer
    extends Thread {
        final ClientSessionFactory factory;
        final ServerLocator locator;
        final ClientSession consumerSession;
        ClientConsumer consumer;
        final int nr;
        final AtomicInteger errors = new AtomicInteger(0);

        SomeConsumer(int nr) throws Exception {
            this.locator = MultipleThreadFilterOneTest.this.createNonHALocator(MultipleThreadFilterOneTest.this.isNetty);
            this.factory = this.locator.createSessionFactory();
            this.consumerSession = this.factory.createSession(false, false);
            this.consumerSession.createQueue(new QueueConfiguration("Q" + nr).setAddress("ADDRESS").setFilterString("prodNR=" + nr));
            this.consumer = this.consumerSession.createConsumer("Q" + nr);
            this.consumerSession.start();
            this.nr = nr;
        }

        @Override
        public void run() {
            try {
                this.consumerSession.start();
                for (int i = 0; i < 2000; ++i) {
                    ClientMessage msg = this.consumer.receive(15000L);
                    Assert.assertNotNull((Object)msg);
                    Assert.assertEquals((long)this.nr, (long)msg.getIntProperty("prodNR").intValue());
                    msg.acknowledge();
                    if (i % 500 != 0) continue;
                    MultipleThreadFilterOneTest.this.instanceLog.debug((Object)("Consumed " + i));
                    this.consumerSession.commit();
                }
                Assert.assertNull((Object)this.consumer.receiveImmediate());
                this.consumerSession.commit();
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.errors.incrementAndGet();
            }
            finally {
                this.close();
            }
        }

        public void close() {
            try {
                this.consumerSession.close();
                this.locator.close();
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
        }
    }

    class SomeProducer
    extends Thread {
        final ClientSessionFactory factory;
        final ServerLocator locator;
        final ClientSession prodSession;
        public final AtomicInteger errors = new AtomicInteger(0);

        SomeProducer() throws Exception {
            this.locator = MultipleThreadFilterOneTest.this.createNonHALocator(MultipleThreadFilterOneTest.this.isNetty);
            this.factory = this.locator.createSessionFactory();
            this.prodSession = this.factory.createSession(false, false);
            this.sendMessages(1000);
        }

        @Override
        public void run() {
            try {
                this.sendMessages(1000);
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.errors.incrementAndGet();
            }
            finally {
                try {
                    this.prodSession.close();
                    this.locator.close();
                }
                catch (Throwable ignored) {
                    ignored.printStackTrace();
                }
            }
        }

        private void sendMessages(int msgs) throws ActiveMQException {
            ClientProducer producer = this.prodSession.createProducer("ADDRESS");
            for (int i = 0; i < msgs; ++i) {
                ClientMessage message = this.prodSession.createMessage(true);
                message.putIntProperty("prodNR", i % 4);
                producer.send((Message)message);
                if (i % 100 != 0) continue;
                this.prodSession.commit();
            }
            this.prodSession.commit();
            producer.close();
        }
    }
}

