/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.HashMap;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.failover.BackupSyncJournalTest;
import org.junit.Before;
import org.junit.Test;

public class BackupSyncPagingTest
extends BackupSyncJournalTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setNumberOfMessages(100);
    }

    protected ActiveMQServer createInVMFailoverServer(boolean realFiles, Configuration configuration, NodeManager nodeManager, int id) {
        HashMap<String, AddressSettings> conf = new HashMap<String, AddressSettings>();
        AddressSettings as = new AddressSettings().setMaxSizeBytes(2048L).setPageSizeBytes(1024).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        conf.put(ADDRESS.toString(), as);
        return this.createInVMFailoverServer(realFiles, configuration, 1024, 2048, conf, nodeManager, id);
    }

    @Test
    public void testReplicationWithPageFileComplete() throws Exception {
        this.setNumberOfMessages(20);
        this.createProducerSendSomeMessages();
        this.backupServer.start();
        BackupSyncPagingTest.waitForRemoteBackup((ClientSessionFactory)this.sessionFactory, (int)60, (boolean)false, (ActiveMQServer)this.backupServer.getServer());
        this.sendMessages(this.session, this.producer, this.getNumberOfMessages());
        this.session.commit();
        this.receiveMsgsInRange(0, this.getNumberOfMessages());
        this.finishSyncAndFailover();
        this.receiveMsgsInRange(0, this.getNumberOfMessages());
        this.assertNoMoreMessages();
    }
}

