/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.crossprotocol;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.Arrays;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MessageIDMultiProtocolTest
extends OpenWireTestBase {
    String protocolSender;
    String protocolConsumer;
    ConnectionFactory senderCF;
    ConnectionFactory consumerCF;
    private static final SimpleString queueName = SimpleString.toSimpleString((String)"MessageIDueueTest");

    public MessageIDMultiProtocolTest(String protocolSender, String protocolConsumer) {
        this.protocolSender = protocolSender;
        this.protocolConsumer = protocolConsumer;
    }

    @Parameterized.Parameters(name="sender={0},consumer={1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"OPENWIRE", "OPENWIRE"}, {"OPENWIRE", "CORE"}, {"OPENWIRE", "AMQP"}, {"CORE", "OPENWIRE"}, {"CORE", "CORE"}, {"CORE", "AMQP"}, {"AMQP", "OPENWIRE"}, {"AMQP", "CORE"}, {"AMQP", "AMQP"});
    }

    @Before
    public void setupCF() {
        this.senderCF = CFUtil.createConnectionFactory(this.protocolSender, "tcp://localhost:61616?wireFormat.cacheEnabled=true");
        this.consumerCF = CFUtil.createConnectionFactory(this.protocolConsumer, "tcp://localhost:61616?wireFormat.cacheEnabled=true");
    }

    @Before
    public void setupQueue() throws Exception {
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isStarted());
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        this.server.createQueue(new QueueConfiguration(queueName).setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testMessageIDNotNullCorrelationIDPreserved() throws Throwable {
        Connection senderConn = this.senderCF.createConnection();
        Connection consumerConn = this.consumerCF.createConnection();
        consumerConn.setClientID("consumer");
        try (Session senderSession = senderConn.createSession(false, 1);){
            Queue senderDestination = senderSession.createQueue(queueName.toString());
            MessageProducer senderProducer = senderSession.createProducer((Destination)senderDestination);
            Message sentMessage = senderSession.createMessage();
            sentMessage.setJMSCorrelationID("ID:MessageIDCorrelationId");
            senderProducer.send(sentMessage);
            senderConn.start();
            String sentMid = sentMessage.getJMSMessageID();
            try (Session consumerSess = consumerConn.createSession(false, 1);){
                Queue consumerDestination = consumerSess.createQueue(queueName.toString());
                MessageConsumer consumer = consumerSess.createConsumer((Destination)consumerDestination);
                consumerConn.start();
                Message receivedMessage = consumer.receive(3000L);
                Assert.assertNotNull((Object)receivedMessage);
                Assert.assertEquals((Object)sentMessage.getJMSCorrelationID(), (Object)receivedMessage.getJMSCorrelationID());
                String messageId = receivedMessage.getJMSMessageID();
                Assert.assertNotNull((Object)messageId);
                Assert.assertTrue((boolean)messageId.startsWith("ID:"));
                this.instanceLog.debug((Object)("[" + this.protocolSender + "][" + this.protocolConsumer + "] " + messageId));
                this.instanceLog.debug((Object)("[" + this.protocolSender + "][" + this.protocolConsumer + "] " + sentMid));
                if (this.protocolConsumer.equals(this.protocolSender)) {
                    MessageIDMultiProtocolTest.assertEquals((Object)sentMid, (Object)messageId);
                }
                if ("CORE".equals(this.protocolSender) && "AMQP".equals(this.protocolConsumer)) {
                    MessageIDMultiProtocolTest.assertEquals((Object)sentMid, (Object)messageId);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                senderConn.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

