/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerPlugin;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JMSXUserIDPluginTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private SimpleString ADDRESS = new SimpleString("TestQueue");

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultNettyConfig(), (boolean)true));
        JMSXUserIDPlugin plugin = new JMSXUserIDPlugin();
        plugin.setPopulateValidatedUser("testuser");
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)plugin);
        this.server.start();
        this.server.createQueue(new QueueConfiguration(this.ADDRESS).setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testAddValidatedUserCore() throws Exception {
        ServerLocator locator = this.createNettyNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, true, true);
        ClientProducer producer = session.createProducer(this.ADDRESS.toString());
        producer.send((org.apache.activemq.artemis.api.core.Message)session.createMessage(true));
        ClientConsumer consumer = session.createConsumer(this.ADDRESS.toString());
        session.start();
        ClientMessage clientMessage = consumer.receiveImmediate();
        Assert.assertNotNull((Object)clientMessage);
        Assert.assertEquals((Object)clientMessage.getValidatedUserID(), (Object)"testuser");
    }

    @Test
    public void testAddValidatedUserAMQP() throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://127.0.0.1:61616");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(this.ADDRESS.toString());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send(session.createMessage());
        connection.close();
        this.server.stop();
        this.server.start();
        connection = factory.createConnection();
        session = connection.createSession(false, 1);
        connection.start();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message message = consumer.receive(5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)message.getStringProperty("_AMQ_VALIDATED_USER"), (Object)"testuser");
        connection.close();
    }

    private static class JMSXUserIDPlugin
    implements ActiveMQServerPlugin {
        private static String POPULATE_VALIDATED_USER = "POPULATE_VALIDATED_USER";
        private String populateValidatedUser;

        private JMSXUserIDPlugin() {
        }

        public void init(Map<String, String> properties) {
            this.populateValidatedUser = properties.getOrDefault(POPULATE_VALIDATED_USER, null);
        }

        public void beforeSend(ServerSession session, Transaction tx, org.apache.activemq.artemis.api.core.Message message, boolean direct, boolean noAutoCreateQueue) throws ActiveMQException {
            if (this.populateValidatedUser != null && !message.containsProperty(org.apache.activemq.artemis.api.core.Message.HDR_VALIDATED_USER)) {
                message.messageChanged();
                message.putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_VALIDATED_USER, this.populateValidatedUser);
            }
        }

        public String getPopulateValidatedUser() {
            return this.populateValidatedUser;
        }

        public void setPopulateValidatedUser(String populateValidatedUser) {
            this.populateValidatedUser = populateValidatedUser;
        }
    }
}

