/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import io.undertow.UndertowOptions;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.DynamicNameMappers;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.deployment.GlobalRequestControllerHandler;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.ssl.XnioSsl;

public class ReverseProxyHandlerHost
extends PersistentResourceDefinition {
    private static final RuntimeCapability<Void> REVERSE_PROXY_HOST_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.reverse-proxy.host", (boolean)true, ReverseProxyHostService.class).setDynamicNameMapper(DynamicNameMappers.PARENT).build();
    public static final SimpleAttributeDefinition OUTBOUND_SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("outbound-socket-binding", ModelType.STRING).setRequired(true)).setValidator((ParameterValidator)new StringLengthValidator(1, false))).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).setCapabilityReference("org.wildfly.network.outbound-socket-binding")).build();
    public static final AttributeDefinition SCHEME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("scheme", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode("http"))).setRestartAllServices()).build();
    public static final AttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode("/"))).setRestartAllServices()).build();
    public static final AttributeDefinition INSTANCE_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("instance-id", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-context", ModelType.STRING, true).setAlternatives(new String[]{"security-realm"})).setCapabilityReference("org.wildfly.security.ssl-context")).setRestartAllServices()).setValidator((ParameterValidator)new StringLengthValidator(1))).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SSL_REF})).build();
    public static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING).setAlternatives(new String[]{"ssl-context"})).setRequired(false)).setRestartAllServices()).setValidator((ParameterValidator)new StringLengthValidator(1))).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SECURITY_REALM_REF})).setDeprecated(ModelVersion.create((int)12))).build();
    public static final SimpleAttributeDefinition ENABLE_HTTP2 = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-http2", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.FALSE)).setRestartAllServices()).build();
    public static final ReverseProxyHandlerHost INSTANCE = new ReverseProxyHandlerHost();

    private ReverseProxyHandlerHost() {
        super(new PersistentResourceDefinition.Parameters(PathElement.pathElement((String)"host"), (ResourceDescriptionResolver)UndertowExtension.getResolver("handler", "reverse-proxy", "host")).setCapabilities(new RuntimeCapability[]{REVERSE_PROXY_HOST_RUNTIME_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(OUTBOUND_SOCKET_BINDING, SCHEME, INSTANCE_ID, PATH, SSL_CONTEXT, SECURITY_REALM, ENABLE_HTTP2);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        ReverseProxyHostAdd add = new ReverseProxyHostAdd(this.getAttributes());
        this.registerAddOperation(resourceRegistration, add, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
        this.registerRemoveOperation(resourceRegistration, (AbstractRemoveStepHandler)new ServiceRemoveStepHandler(add){

            protected ServiceName serviceName(String name, PathAddress address) {
                return REVERSE_PROXY_HOST_RUNTIME_CAPABILITY.getCapabilityServiceName(address);
            }
        }, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
    }

    private static final class ReverseProxyHostService
    implements Service {
        private final Consumer<ReverseProxyHostService> serviceConsumer;
        private final Supplier<HttpHandler> proxyHandler;
        private final Supplier<OutboundSocketBinding> socketBinding;
        private final Supplier<SSLContext> sslContext;
        private final String instanceId;
        private final String scheme;
        private final String path;
        private final boolean enableHttp2;

        private ReverseProxyHostService(Consumer<ReverseProxyHostService> serviceConsumer, Supplier<HttpHandler> proxyHandler, Supplier<OutboundSocketBinding> socketBinding, Supplier<SSLContext> sslContext, String scheme, String instanceId, String path, boolean enableHttp2) {
            this.serviceConsumer = serviceConsumer;
            this.proxyHandler = proxyHandler;
            this.socketBinding = socketBinding;
            this.sslContext = sslContext;
            this.instanceId = instanceId;
            this.scheme = scheme;
            this.path = path;
            this.enableHttp2 = enableHttp2;
        }

        private URI getUri() throws URISyntaxException {
            OutboundSocketBinding binding = this.socketBinding.get();
            return new URI(this.scheme, null, binding.getUnresolvedDestinationAddress(), binding.getDestinationPort(), this.path, null, null);
        }

        public void start(StartContext startContext) throws StartException {
            ProxyHandler proxyHandler = (ProxyHandler)(this.proxyHandler.get() instanceof GlobalRequestControllerHandler ? ((GlobalRequestControllerHandler)this.proxyHandler.get()).getNext() : this.proxyHandler.get());
            LoadBalancingProxyClient client = (LoadBalancingProxyClient)proxyHandler.getProxyClient();
            try {
                SSLContext sslContext;
                SSLContext sSLContext = sslContext = this.sslContext != null ? this.sslContext.get() : null;
                if (sslContext == null) {
                    client.addHost(this.getUri(), this.instanceId, null, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)this.enableHttp2));
                } else {
                    OptionMap.Builder builder = OptionMap.builder();
                    builder.set(Options.USE_DIRECT_BUFFERS, true);
                    OptionMap combined = builder.getMap();
                    UndertowXnioSsl xnioSsl = new UndertowXnioSsl(Xnio.getInstance(), combined, sslContext);
                    client.addHost(this.getUri(), this.instanceId, (XnioSsl)xnioSsl, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)this.enableHttp2));
                }
                this.serviceConsumer.accept(this);
            }
            catch (URISyntaxException e) {
                throw new StartException((Throwable)e);
            }
        }

        public void stop(StopContext stopContext) {
            this.serviceConsumer.accept(null);
            ProxyHandler proxyHandler = (ProxyHandler)(this.proxyHandler.get() instanceof GlobalRequestControllerHandler ? ((GlobalRequestControllerHandler)this.proxyHandler.get()).getNext() : this.proxyHandler.get());
            LoadBalancingProxyClient client = (LoadBalancingProxyClient)proxyHandler.getProxyClient();
            try {
                client.removeHost(this.getUri());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ReverseProxyHostAdd
    extends AbstractAddStepHandler {
        public ReverseProxyHostAdd(Collection<AttributeDefinition> attributes) {
            super(attributes);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress();
            String proxyName = address.getElement(address.size() - 2).getValue();
            String socketBinding = OUTBOUND_SOCKET_BINDING.resolveModelAttribute(context, model).asString();
            String scheme = SCHEME.resolveModelAttribute(context, model).asString();
            String path = PATH.resolveModelAttribute(context, model).asString();
            boolean enableHttp2 = ENABLE_HTTP2.resolveModelAttribute(context, model).asBoolean();
            ModelNode securityRealm = SECURITY_REALM.resolveModelAttribute(context, model);
            if (securityRealm.isDefined()) {
                throw UndertowLogger.ROOT_LOGGER.runtimeSecurityRealmUnsupported();
            }
            ModelNode sslContext = SSL_CONTEXT.resolveModelAttribute(context, model);
            String jvmRoute = model.hasDefined("instance-id") ? INSTANCE_ID.resolveModelAttribute(context, model).asString() : null;
            CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addCapability(REVERSE_PROXY_HOST_RUNTIME_CAPABILITY);
            Consumer serviceConsumer = sb.provides(new RuntimeCapability[]{REVERSE_PROXY_HOST_RUNTIME_CAPABILITY});
            Supplier phSupplier = sb.requiresCapability("org.wildfly.extension.undertow.handler", HttpHandler.class, new String[]{proxyName});
            Supplier sbSupplier = sb.requiresCapability("org.wildfly.network.outbound-socket-binding", OutboundSocketBinding.class, new String[]{socketBinding});
            Supplier scSupplier = sslContext.isDefined() ? sb.requiresCapability("org.wildfly.security.ssl-context", SSLContext.class, new String[]{sslContext.asString()}) : null;
            sb.setInstance((Service)new ReverseProxyHostService(serviceConsumer, phSupplier, sbSupplier, scSupplier, scheme, jvmRoute, path, enableHttp2));
            sb.install();
        }
    }
}

