/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.fault;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaConsumer;
import io.smallrye.reactive.messaging.kafka.fault.KafkaFailureHandler;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.vertx.mutiny.core.Vertx;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.function.BiConsumer;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class KafkaFailStop
implements KafkaFailureHandler {
    private final String channel;
    private final BiConsumer<Throwable, Boolean> reportFailure;

    public <K, V> KafkaFailStop(String channel, BiConsumer<Throwable, Boolean> reportFailure) {
        this.channel = channel;
        this.reportFailure = reportFailure;
    }

    @Override
    public <K, V> Uni<Void> handle(IncomingKafkaRecord<K, V> record, Throwable reason, Metadata metadata) {
        KafkaLogging.log.messageNackedFailStop(this.channel);
        this.reportFailure.accept(reason, true);
        return Uni.createFrom().failure(reason).emitOn(arg_0 -> record.runOnMessageContext(arg_0));
    }

    @ApplicationScoped
    @Identifier(value="fail")
    public static class Factory
    implements KafkaFailureHandler.Factory {
        @Override
        public KafkaFailureHandler create(KafkaConnectorIncomingConfiguration config, Vertx vertx, KafkaConsumer<?, ?> consumer, BiConsumer<Throwable, Boolean> reportFailure) {
            return new KafkaFailStop(config.getChannel(), reportFailure);
        }
    }
}

