/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Subscription;

public final class MultiOnSubscribeCall<T>
extends AbstractMultiOperator<T, T> {
    private final Function<? super Subscription, Uni<?>> onSubscribe;

    public MultiOnSubscribeCall(Multi<? extends T> upstream, Function<? super Subscription, Uni<?>> onSubscribe) {
        super(upstream);
        this.onSubscribe = onSubscribe;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        if (actual == null) {
            throw new NullPointerException("Subscriber must not be `null`");
        }
        this.upstream.subscribe().withSubscriber(new OnSubscribeSubscriber(actual));
    }

    private final class OnSubscribeSubscriber
    extends MultiOperatorProcessor<T, T> {
        OnSubscribeSubscriber(MultiSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (this.compareAndSetUpstreamSubscription(null, s)) {
                try {
                    Uni uni = Objects.requireNonNull((Uni)MultiOnSubscribeCall.this.onSubscribe.apply(s), "The produced Uni must not be `null`");
                    uni.subscribe().with(ignored -> this.downstream.onSubscribe(this), failure -> {
                        Subscriptions.fail(this.downstream, failure);
                        this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED).cancel();
                    });
                }
                catch (Throwable e) {
                    Subscriptions.fail(this.downstream, e);
                    this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED).cancel();
                }
            } else {
                s.cancel();
            }
        }
    }
}

