/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.analysis.impl.ScopedAnalyzer;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneNestablePredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LucenePredicateTypeKeys;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneSimpleQueryStringPredicateBuilderFieldState;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.common.spi.SearchIndexSchemaElementContextHelper;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryFlag;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneSimpleQueryStringPredicate
extends AbstractLuceneNestablePredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final List<String> nestedPathHierarchy;
    private final List<String> fieldPaths;
    private final Query query;

    private LuceneSimpleQueryStringPredicate(Builder builder) {
        super(builder);
        this.nestedPathHierarchy = builder.firstFieldState.field().nestedPathHierarchy();
        this.fieldPaths = new ArrayList(builder.fieldStates.keySet());
        this.query = builder.buildQuery();
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        return this.query;
    }

    @Override
    protected List<String> getNestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    @Override
    protected List<String> getFieldPathsForErrorMessage() {
        return this.fieldPaths;
    }

    public static class Builder
    extends AbstractLuceneSearchPredicate.AbstractBuilder
    implements SimpleQueryStringPredicateBuilder {
        private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
        private LuceneSimpleQueryStringPredicateBuilderFieldState firstFieldState;
        private final Map<String, LuceneSimpleQueryStringPredicateBuilderFieldState> fieldStates = new LinkedHashMap<String, LuceneSimpleQueryStringPredicateBuilderFieldState>();
        private BooleanClause.Occur defaultOperator = BooleanClause.Occur.SHOULD;
        private String simpleQueryString;
        private Analyzer overrideAnalyzer;
        private boolean ignoreAnalyzer = false;
        private int flags = -1;

        Builder(LuceneSearchIndexScope<?> scope) {
            super(scope);
            this.analysisDefinitionRegistry = scope.analysisDefinitionRegistry();
        }

        public void defaultOperator(BooleanOperator operator) {
            switch (operator) {
                case AND: {
                    this.defaultOperator = BooleanClause.Occur.MUST;
                    break;
                }
                case OR: {
                    this.defaultOperator = BooleanClause.Occur.SHOULD;
                }
            }
        }

        public void flags(Set<SimpleQueryFlag> flags) {
            this.flags = Builder.toFlagsMask(flags);
        }

        public SimpleQueryStringPredicateBuilder.FieldState field(String fieldPath) {
            LuceneSimpleQueryStringPredicateBuilderFieldState fieldState = this.fieldStates.get(fieldPath);
            if (fieldState == null) {
                fieldState = (LuceneSimpleQueryStringPredicateBuilderFieldState)this.scope.fieldQueryElement(fieldPath, LucenePredicateTypeKeys.SIMPLE_QUERY_STRING);
                if (this.firstFieldState == null) {
                    this.firstFieldState = fieldState;
                } else {
                    SearchIndexSchemaElementContextHelper.checkNestedDocumentPathCompatibility(this.firstFieldState.field(), fieldState.field());
                }
                this.fieldStates.put(fieldPath, fieldState);
            }
            return fieldState;
        }

        public void simpleQueryString(String simpleQueryString) {
            this.simpleQueryString = simpleQueryString;
        }

        public void analyzer(String analyzerName) {
            this.overrideAnalyzer = this.analysisDefinitionRegistry.getAnalyzerDefinition(analyzerName);
            if (this.overrideAnalyzer == null) {
                throw log.unknownAnalyzer(analyzerName, EventContexts.fromIndexNames((Set)this.scope.hibernateSearchIndexNames()));
            }
        }

        public void skipAnalysis() {
            this.ignoreAnalyzer = true;
        }

        public SearchPredicate build() {
            return new LuceneSimpleQueryStringPredicate(this);
        }

        private Query buildQuery() {
            SimpleQueryParser queryParser = new SimpleQueryParser(this.buildAnalyzer(), this.buildWeights(), this.flags);
            queryParser.setDefaultOperator(this.defaultOperator);
            return queryParser.parse(this.simpleQueryString);
        }

        private Analyzer buildAnalyzer() {
            if (this.ignoreAnalyzer) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            if (this.overrideAnalyzer != null) {
                return this.overrideAnalyzer;
            }
            if (this.fieldStates.size() == 1) {
                return this.fieldStates.values().iterator().next().field().type().searchAnalyzerOrNormalizer();
            }
            ScopedAnalyzer.Builder builder = new ScopedAnalyzer.Builder();
            for (LuceneSimpleQueryStringPredicateBuilderFieldState state : this.fieldStates.values()) {
                builder.setAnalyzer(state.field().absolutePath(), state.field().type().searchAnalyzerOrNormalizer());
            }
            return builder.build();
        }

        private Map<String, Float> buildWeights() {
            LinkedHashMap<String, Float> weights = new LinkedHashMap<String, Float>();
            for (LuceneSimpleQueryStringPredicateBuilderFieldState state : this.fieldStates.values()) {
                Float boost = state.boost();
                if (boost == null) {
                    boost = Float.valueOf(1.0f);
                }
                weights.put(state.field().absolutePath(), boost);
            }
            return weights;
        }

        private static int toFlagsMask(Set<SimpleQueryFlag> flags) {
            int flag = -1;
            if (flags != null) {
                flag = 0;
                for (SimpleQueryFlag operation : flags) {
                    switch (operation) {
                        case AND: {
                            flag |= 1;
                            break;
                        }
                        case NOT: {
                            flag |= 2;
                            break;
                        }
                        case OR: {
                            flag |= 4;
                            break;
                        }
                        case PREFIX: {
                            flag |= 8;
                            break;
                        }
                        case PHRASE: {
                            flag |= 0x10;
                            break;
                        }
                        case PRECEDENCE: {
                            flag |= 0x20;
                            break;
                        }
                        case ESCAPE: {
                            flag |= 0x40;
                            break;
                        }
                        case WHITESPACE: {
                            flag |= 0x80;
                            break;
                        }
                        case FUZZY: {
                            flag |= 0x100;
                            break;
                        }
                        case NEAR: {
                            flag |= 0x200;
                        }
                    }
                }
            }
            return flag;
        }
    }
}

