/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientLogger;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.jms.client.JMSExceptionHelper;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQCompatibleMessage;
import org.apache.activemq.artemis.utils.SelectorTranslator;

public final class ActiveMQQueueBrowser
implements QueueBrowser {
    private final ConnectionFactoryOptions options;
    private final ClientSession session;
    private ClientConsumer consumer;
    private final ActiveMQQueue queue;
    private SimpleString filterString;
    private final boolean enable1xPrefixes;

    protected ActiveMQQueueBrowser(ConnectionFactoryOptions options, ActiveMQQueue queue, String messageSelector, ClientSession session, boolean enable1xPrefixes) throws JMSException {
        this.options = options;
        this.session = session;
        this.queue = queue;
        if (messageSelector != null) {
            this.filterString = new SimpleString(SelectorTranslator.convertToActiveMQFilterString((String)messageSelector));
        }
        this.enable1xPrefixes = enable1xPrefixes;
    }

    public void close() throws JMSException {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (ActiveMQException e) {
                throw JMSExceptionHelper.convertFromActiveMQException(e);
            }
        }
    }

    public Enumeration getEnumeration() throws JMSException {
        try {
            this.close();
            this.consumer = this.session.createConsumer(this.queue.getSimpleAddress(), this.filterString, true);
            return new BrowserEnumeration();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public String getMessageSelector() throws JMSException {
        return this.filterString == null ? null : this.filterString.toString();
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    public String toString() {
        return "ActiveMQQueueBrowser->" + this.consumer;
    }

    private final class BrowserEnumeration
    implements Enumeration<ActiveMQMessage> {
        ClientMessage current = null;

        private BrowserEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            if (this.current == null) {
                try {
                    this.current = ActiveMQQueueBrowser.this.consumer.receiveImmediate();
                }
                catch (ActiveMQException e) {
                    return false;
                }
            }
            return this.current != null;
        }

        @Override
        public ActiveMQMessage nextElement() {
            if (this.hasMoreElements()) {
                ClientMessage next = this.current;
                this.current = null;
                ActiveMQMessage msg = ActiveMQQueueBrowser.this.enable1xPrefixes ? ActiveMQCompatibleMessage.createMessage(next, ActiveMQQueueBrowser.this.session, ActiveMQQueueBrowser.this.options) : ActiveMQMessage.createMessage(next, ActiveMQQueueBrowser.this.session, ActiveMQQueueBrowser.this.options);
                try {
                    msg.doBeforeReceive();
                }
                catch (Exception e) {
                    ActiveMQJMSClientLogger.LOGGER.errorCreatingMessage(msg.getCoreMessage().toString(), e);
                    return null;
                }
                return msg;
            }
            throw new NoSuchElementException();
        }
    }
}

