/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.ParameterMisuseException;
import org.hibernate.procedure.ProcedureOutputs;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.query.procedure.ProcedureParameter;
import org.hibernate.result.Output;
import org.hibernate.result.internal.OutputsImpl;
import org.hibernate.sql.exec.ExecutionException;
import org.hibernate.sql.exec.spi.JdbcCallParameterRegistration;
import org.hibernate.sql.exec.spi.JdbcCallRefCursorExtractor;

public class ProcedureOutputsImpl
extends OutputsImpl
implements ProcedureOutputs {
    private final ProcedureCallImpl<?> procedureCall;
    private final CallableStatement callableStatement;
    private final Map<ProcedureParameter<?>, JdbcCallParameterRegistration> parameterRegistrations;
    private final JdbcCallRefCursorExtractor[] refCursorParameters;
    private int refCursorParamIndex;

    ProcedureOutputsImpl(ProcedureCallImpl<?> procedureCall, Map<ProcedureParameter<?>, JdbcCallParameterRegistration> parameterRegistrations, JdbcCallRefCursorExtractor[] refCursorParameters, CallableStatement callableStatement) {
        super(procedureCall, callableStatement);
        this.procedureCall = procedureCall;
        this.callableStatement = callableStatement;
        this.parameterRegistrations = parameterRegistrations;
        this.refCursorParameters = refCursorParameters;
        if (procedureCall.getFunctionReturn() != null && procedureCall.getFunctionReturn().getMode() != ParameterMode.REF_CURSOR) {
            this.refCursorParamIndex = -1;
        }
        this.executeStatement();
    }

    @Override
    public <T> T getOutputParameterValue(ProcedureParameter<T> parameter) {
        if (parameter.getMode() == ParameterMode.IN) {
            throw new ParameterMisuseException("IN parameter not valid for output extraction");
        }
        JdbcCallParameterRegistration registration = this.parameterRegistrations.get(parameter);
        if (registration == null) {
            throw new IllegalArgumentException("Parameter [" + parameter + "] is not registered with this procedure call");
        }
        try {
            if (registration.getParameterMode() == ParameterMode.REF_CURSOR) {
                return (T)registration.getRefCursorExtractor().extractResultSet(this.callableStatement, (SharedSessionContractImplementor)this.procedureCall.getSession());
            }
            return registration.getParameterExtractor().extractValue(this.callableStatement, parameter.getPosition() == null, (SharedSessionContractImplementor)this.procedureCall.getSession());
        }
        catch (Exception e) {
            throw new ExecutionException("Error extracting procedure output parameter value [" + parameter + "]", e);
        }
    }

    @Override
    public Object getOutputParameterValue(String name) {
        return this.getOutputParameterValue((ProcedureParameter)((Object)this.procedureCall.getParameterMetadata().getQueryParameter(name)));
    }

    @Override
    public Object getOutputParameterValue(int position) {
        return this.getOutputParameterValue((ProcedureParameter)((Object)this.procedureCall.getParameterMetadata().getQueryParameter(position)));
    }

    @Override
    protected OutputsImpl.CurrentReturnState buildCurrentReturnState(boolean isResultSet, int updateCount) {
        return new ProcedureCurrentReturnState(isResultSet, updateCount, this.refCursorParamIndex);
    }

    @Override
    public void release() {
        super.release();
        this.getResultContext().getSession().getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(this.callableStatement);
    }

    protected class ProcedureCurrentReturnState
    extends OutputsImpl.CurrentReturnState {
        private final int refCursorParamIndex;

        private ProcedureCurrentReturnState(boolean isResultSet, int updateCount, int refCursorParamIndex) {
            super(ProcedureOutputsImpl.this, isResultSet, updateCount);
            this.refCursorParamIndex = refCursorParamIndex;
        }

        @Override
        public boolean indicatesMoreOutputs() {
            return super.indicatesMoreOutputs() || ProcedureOutputsImpl.this.refCursorParamIndex < ProcedureOutputsImpl.this.refCursorParameters.length;
        }

        @Override
        protected boolean hasExtendedReturns() {
            return this.refCursorParamIndex < ProcedureOutputsImpl.this.refCursorParameters.length;
        }

        @Override
        protected Output buildExtendedReturn() {
            if (ProcedureOutputsImpl.this.refCursorParamIndex == -1) {
                ProcedureOutputsImpl.this.refCursorParamIndex = 0;
                Object outputParameterValue = ProcedureOutputsImpl.this.getOutputParameterValue(ProcedureOutputsImpl.this.procedureCall.getFunctionReturn());
                return this.buildResultSetOutput(() -> {
                    if (outputParameterValue instanceof ResultSet) {
                        return ProcedureOutputsImpl.this.extractResults((ResultSet)outputParameterValue);
                    }
                    return List.of(outputParameterValue);
                });
            }
            JdbcCallRefCursorExtractor refCursorParam = ProcedureOutputsImpl.this.refCursorParameters[ProcedureOutputsImpl.this.refCursorParamIndex++];
            ResultSet resultSet = refCursorParam.extractResultSet(ProcedureOutputsImpl.this.callableStatement, (SharedSessionContractImplementor)ProcedureOutputsImpl.this.procedureCall.getSession());
            return this.buildResultSetOutput(() -> ProcedureOutputsImpl.this.extractResults(resultSet));
        }
    }
}

