/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.MutableBoolean;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.MappingModelHelper;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.mutation.internal.TableKeyExpressionCollector;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithTemporaryTableHelper;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithoutIdTableHelper;
import org.hibernate.query.sqm.mutation.internal.temptable.TableBasedDeleteHandler;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.PredicateCollector;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.jboss.logging.Logger;

public class RestrictedDeleteExecutionDelegate
implements TableBasedDeleteHandler.ExecutionDelegate {
    private static final Logger log = Logger.getLogger(RestrictedDeleteExecutionDelegate.class);
    private final EntityMappingType entityDescriptor;
    private final TemporaryTable idTable;
    private final AfterUseAction afterUseAction;
    private final SqmDeleteStatement<?> sqmDelete;
    private final DomainParameterXref domainParameterXref;
    private final SessionFactoryImplementor sessionFactory;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final MultiTableSqmMutationConverter converter;

    public RestrictedDeleteExecutionDelegate(EntityMappingType entityDescriptor, TemporaryTable idTable, AfterUseAction afterUseAction, SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref, Function<SharedSessionContractImplementor, String> sessionUidAccess, QueryOptions queryOptions, LoadQueryInfluencers loadQueryInfluencers, QueryParameterBindings queryParameterBindings, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.idTable = idTable;
        this.afterUseAction = afterUseAction;
        this.sqmDelete = sqmDelete;
        this.domainParameterXref = domainParameterXref;
        this.sessionUidAccess = sessionUidAccess;
        this.sessionFactory = sessionFactory;
        this.converter = new MultiTableSqmMutationConverter(entityDescriptor, (SqmStatement<?>)sqmDelete, (SqmRoot<?>)sqmDelete.getTarget(), domainParameterXref, queryOptions, loadQueryInfluencers, queryParameterBindings, sessionFactory);
    }

    @Override
    public int execute(DomainQueryExecutionContext executionContext) {
        Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions;
        Map<SqmParameter<?>, List<List<JdbcParameter>>> parameterResolutions;
        EntityPersister entityDescriptor = this.sessionFactory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(((SqmRoot)this.sqmDelete.getTarget()).getEntityName());
        String hierarchyRootTableName = ((Joinable)((Object)entityDescriptor)).getTableName();
        TableGroup deletingTableGroup = this.converter.getMutatingTableGroup();
        TableReference hierarchyRootTableReference = deletingTableGroup.resolveTableReference(deletingTableGroup.getNavigablePath(), hierarchyRootTableName);
        assert (hierarchyRootTableReference != null);
        if (this.domainParameterXref.getSqmParameterCount() == 0) {
            parameterResolutions = Collections.emptyMap();
            paramTypeResolutions = Collections.emptyMap();
        } else {
            parameterResolutions = new IdentityHashMap();
            paramTypeResolutions = new LinkedHashMap();
        }
        MutableBoolean needsIdTableWrapper = new MutableBoolean(false);
        Predicate specifiedRestriction = this.converter.visitWhereClause(this.sqmDelete.getWhereClause(), columnReference -> {
            if (!hierarchyRootTableReference.getIdentificationVariable().equals(columnReference.getQualifier())) {
                needsIdTableWrapper.setValue(true);
            }
        }, (sqmParameter, mappingType, jdbcParameters) -> {
            parameterResolutions.computeIfAbsent(sqmParameter, k -> new ArrayList(1)).add(jdbcParameters);
            paramTypeResolutions.put(sqmParameter, mappingType);
        });
        PredicateCollector predicateCollector = new PredicateCollector(specifiedRestriction);
        entityDescriptor.applyBaseRestrictions(filterPredicate -> {
            needsIdTableWrapper.setValue(true);
            predicateCollector.applyPredicate((Predicate)filterPredicate);
        }, deletingTableGroup, true, executionContext.getSession().getLoadQueryInfluencers().getEnabledFilters(), null, this.converter);
        this.converter.pruneTableGroupJoins();
        boolean needsIdTable = needsIdTableWrapper.getValue() || entityDescriptor != entityDescriptor.getRootEntityDescriptor();
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext);
        if (needsIdTable) {
            return this.executeWithIdTable(predicateCollector.getPredicate(), deletingTableGroup, parameterResolutions, paramTypeResolutions, executionContextAdapter);
        }
        return this.executeWithoutIdTable(predicateCollector.getPredicate(), deletingTableGroup, parameterResolutions, paramTypeResolutions, this.converter.getSqlExpressionResolver(), executionContextAdapter);
    }

    private int executeWithoutIdTable(Predicate suppliedPredicate, TableGroup tableGroup, Map<SqmParameter<?>, List<List<JdbcParameter>>> restrictionSqmParameterResolutions, final Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions, SqlExpressionResolver sqlExpressionResolver, ExecutionContext executionContext) {
        assert (this.entityDescriptor == this.entityDescriptor.getRootEntityDescriptor());
        EntityPersister rootEntityPersister = this.entityDescriptor.getEntityPersister();
        String rootTableName = ((Joinable)((Object)rootEntityPersister)).getTableName();
        NamedTableReference rootTableReference = (NamedTableReference)tableGroup.resolveTableReference(tableGroup.getNavigablePath(), rootTableName);
        QuerySpec matchingIdSubQuerySpec = ExecuteWithoutIdTableHelper.createIdMatchingSubQuerySpec(tableGroup.getNavigablePath(), rootTableReference, suppliedPredicate, rootEntityPersister, sqlExpressionResolver, this.sessionFactory);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, SqmUtil.generateJdbcParamsXref(this.domainParameterXref, () -> restrictionSqmParameterResolutions), this.sessionFactory.getRuntimeMetamodels().getMappingMetamodel(), navigablePath -> tableGroup, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)paramTypeResolutions.get(parameter);
            }
        }, executionContext.getSession());
        SqmMutationStrategyHelper.cleanUpCollectionTables(this.entityDescriptor, (tableReference, attributeMapping) -> {
            if (suppliedPredicate == null) {
                return null;
            }
            ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
            QuerySpec idSelectFkSubQuery = fkDescriptor.getTargetPart() instanceof EntityIdentifierMapping ? matchingIdSubQuerySpec : ExecuteWithoutIdTableHelper.createIdMatchingSubQuerySpec(tableGroup.getNavigablePath(), rootTableReference, suppliedPredicate, rootEntityPersister, sqlExpressionResolver, this.sessionFactory);
            return new InSubQueryPredicate(MappingModelHelper.buildColumnReferenceExpression(fkDescriptor, null, this.sessionFactory), idSelectFkSubQuery, false);
        }, jdbcParameterBindings, executionContext);
        if (rootTableReference instanceof UnionTableReference) {
            MutableInteger rows = new MutableInteger();
            this.entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> {
                NamedTableReference tableReference = new NamedTableReference(tableExpression, tableGroup.getPrimaryTableReference().getIdentificationVariable(), false, this.sessionFactory);
                QuerySpec idMatchingSubQuerySpec = suppliedPredicate == null ? null : matchingIdSubQuerySpec;
                rows.plus(this.deleteFromNonRootTableWithoutIdTable(tableReference, tableKeyColumnVisitationSupplier, sqlExpressionResolver, tableGroup, idMatchingSubQuerySpec, jdbcParameterBindings, executionContext));
            });
            return rows.get();
        }
        this.entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> {
            if (!tableExpression.equals(rootTableName)) {
                NamedTableReference tableReference = (NamedTableReference)tableGroup.getTableReference(tableGroup.getNavigablePath(), tableExpression, true, true);
                QuerySpec idMatchingSubQuerySpec = suppliedPredicate == null ? null : matchingIdSubQuerySpec;
                this.deleteFromNonRootTableWithoutIdTable(tableReference, tableKeyColumnVisitationSupplier, sqlExpressionResolver, tableGroup, idMatchingSubQuerySpec, jdbcParameterBindings, executionContext);
            }
        });
        return this.deleteFromRootTableWithoutIdTable(rootTableReference, suppliedPredicate, jdbcParameterBindings, executionContext);
    }

    private int deleteFromRootTableWithoutIdTable(NamedTableReference rootTableReference, Predicate predicate, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        return RestrictedDeleteExecutionDelegate.executeSqlDelete(new DeleteStatement(rootTableReference, predicate), jdbcParameterBindings, executionContext);
    }

    private int deleteFromNonRootTableWithoutIdTable(NamedTableReference targetTableReference, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, SqlExpressionResolver sqlExpressionResolver, TableGroup rootTableGroup, QuerySpec matchingIdSubQuerySpec, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        InSubQueryPredicate tableDeletePredicate;
        assert (targetTableReference != null);
        log.tracef("deleteFromNonRootTable - %s", (Object)targetTableReference.getTableExpression());
        NamedTableReference deleteTableReference = new NamedTableReference(targetTableReference.getTableExpression(), "to_delete_", true, this.sessionFactory);
        if (matchingIdSubQuerySpec == null) {
            tableDeletePredicate = null;
        } else {
            ArrayList deletingTableColumnRefs = new ArrayList();
            tableKeyColumnVisitationSupplier.get().accept((columnIndex, selection) -> {
                assert (deleteTableReference.getTableReference(selection.getContainingTableExpression()) != null);
                Expression expression = sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey((TableReference)deleteTableReference, selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(deleteTableReference, selection, this.sessionFactory));
                deletingTableColumnRefs.add((ColumnReference)expression);
            });
            Expression deletingTableColumnRefsExpression = deletingTableColumnRefs.size() == 1 ? (Expression)deletingTableColumnRefs.get(0) : new SqlTuple(deletingTableColumnRefs, this.entityDescriptor.getIdentifierMapping());
            tableDeletePredicate = new InSubQueryPredicate(deletingTableColumnRefsExpression, matchingIdSubQuerySpec, false);
        }
        DeleteStatement sqlAstDelete = new DeleteStatement(deleteTableReference, tableDeletePredicate);
        int rows = RestrictedDeleteExecutionDelegate.executeSqlDelete(sqlAstDelete, jdbcParameterBindings, executionContext);
        log.debugf("deleteFromNonRootTable - `%s` : %s rows", (Object)targetTableReference, (Object)rows);
        return rows;
    }

    private static int executeSqlDelete(DeleteStatement sqlAst, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        JdbcDelete jdbcDelete = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildDeleteTranslator(factory, sqlAst).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        return jdbcServices.getJdbcMutationExecutor().execute(jdbcDelete, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeWithIdTable(Predicate predicate, TableGroup deletingTableGroup, Map<SqmParameter<?>, List<List<JdbcParameter>>> restrictionSqmParameterResolutions, final Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions, ExecutionContext executionContext) {
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, SqmUtil.generateJdbcParamsXref(this.domainParameterXref, () -> restrictionSqmParameterResolutions), this.sessionFactory.getRuntimeMetamodels().getMappingMetamodel(), navigablePath -> deletingTableGroup, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)paramTypeResolutions.get(parameter);
            }
        }, executionContext.getSession());
        ExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(this.idTable, executionContext);
        try {
            int n = this.executeUsingIdTable(predicate, executionContext, jdbcParameterBindings);
            return n;
        }
        finally {
            ExecuteWithTemporaryTableHelper.performAfterTemporaryTableUseActions(this.idTable, this.sessionUidAccess, this.afterUseAction, executionContext);
        }
    }

    private int executeUsingIdTable(Predicate predicate, ExecutionContext executionContext, JdbcParameterBindings jdbcParameterBindings) {
        int rows = ExecuteWithTemporaryTableHelper.saveMatchingIdsIntoIdTable(this.converter, predicate, this.idTable, this.sessionUidAccess, jdbcParameterBindings, executionContext);
        QuerySpec idTableIdentifierSubQuery = ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(this.idTable, this.sessionUidAccess, this.entityDescriptor, executionContext);
        SqmMutationStrategyHelper.cleanUpCollectionTables(this.entityDescriptor, (tableReference, attributeMapping) -> {
            ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
            QuerySpec idTableFkSubQuery = fkDescriptor.getTargetPart() instanceof EntityIdentifierMapping ? idTableIdentifierSubQuery : ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(this.idTable, fkDescriptor.getTargetPart(), this.sessionUidAccess, this.entityDescriptor, executionContext);
            return new InSubQueryPredicate(MappingModelHelper.buildColumnReferenceExpression(fkDescriptor, null, this.sessionFactory), idTableFkSubQuery, false);
        }, JdbcParameterBindings.NO_BINDINGS, executionContext);
        this.entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> this.deleteFromTableUsingIdTable(tableExpression, tableKeyColumnVisitationSupplier, idTableIdentifierSubQuery, executionContext));
        return rows;
    }

    private void deleteFromTableUsingIdTable(String tableExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, QuerySpec idTableSubQuery, ExecutionContext executionContext) {
        log.tracef("deleteFromTableUsingIdTable - %s", (Object)tableExpression);
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        TableKeyExpressionCollector keyColumnCollector = new TableKeyExpressionCollector(this.entityDescriptor);
        NamedTableReference targetTable = new NamedTableReference(tableExpression, "to_delete_", true, factory);
        tableKeyColumnVisitationSupplier.get().accept((columnIndex, selection) -> {
            assert (selection.getContainingTableExpression().equals(tableExpression));
            assert (!selection.isFormula());
            assert (selection.getCustomReadExpression() == null);
            assert (selection.getCustomWriteExpression() == null);
            keyColumnCollector.apply(new ColumnReference(targetTable, selection, factory));
        });
        InSubQueryPredicate predicate = new InSubQueryPredicate(keyColumnCollector.buildKeyExpression(), idTableSubQuery, false);
        RestrictedDeleteExecutionDelegate.executeSqlDelete(new DeleteStatement(targetTable, predicate), JdbcParameterBindings.NO_BINDINGS, executionContext);
    }
}

