/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import jakarta.transaction.Synchronization;
import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import org.hibernate.Transaction;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.orm.automaticindexing.AutomaticIndexingStrategyName;
import org.hibernate.search.mapper.orm.automaticindexing.impl.HibernateOrmIndexingQueueEventSendingPlan;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.automaticindexing.session.impl.ConfiguredAutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingEventSendingSessionContext;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingQueueEventSendingPlan;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingStrategyStartContext;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmMapperSettings;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerContextProvider;
import org.hibernate.search.mapper.orm.event.impl.HibernateSearchEventListener;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.session.impl.AfterCommitIndexingPlanSynchronization;
import org.hibernate.search.mapper.orm.session.impl.BeforeCommitIndexingPlanSynchronization;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSession;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionHolder;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventProcessingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class ConfiguredAutomaticIndexingStrategy {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Boolean> AUTOMATIC_INDEXING_ENABLED = ConfigurationProperty.forKey((String)"enabled").asBoolean().withDefault((Object)true).build();
    private static final OptionalConfigurationProperty<Boolean> AUTOMATIC_INDEXING_ENABLED_LEGACY_STRATEGY = ConfigurationProperty.forKey((String)"strategy").as(Boolean.class, v -> !AutomaticIndexingStrategyName.NONE.equals((Object)AutomaticIndexingStrategyName.of(v))).build();
    private static final OptionalConfigurationProperty<BeanReference<? extends AutomaticIndexingSynchronizationStrategy>> AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY = ConfigurationProperty.forKey((String)"synchronization.strategy").asBeanReference(AutomaticIndexingSynchronizationStrategy.class).build();
    private static final ConfigurationProperty<Boolean> DIRTY_CHECK_ENABLED = ConfigurationProperty.forKey((String)"enable_dirty_check").asBoolean().withDefault((Object)true).build();
    private final Function<AutomaticIndexingEventSendingSessionContext, AutomaticIndexingQueueEventSendingPlan> senderFactory;
    private final boolean enlistsInTransaction;
    private HibernateOrmSearchSessionMappingContext mappingContext;
    private BeanHolder<? extends AutomaticIndexingSynchronizationStrategy> defaultSynchronizationStrategyHolder;
    private ConfiguredAutomaticIndexingSynchronizationStrategy defaultSynchronizationStrategy;

    public ConfiguredAutomaticIndexingStrategy(Function<AutomaticIndexingEventSendingSessionContext, AutomaticIndexingQueueEventSendingPlan> senderFactory, boolean enlistsInTransaction) {
        this.senderFactory = senderFactory;
        this.enlistsInTransaction = enlistsInTransaction;
    }

    public boolean usesEventQueue() {
        return this.senderFactory != null;
    }

    public void start(HibernateOrmSearchSessionMappingContext mappingContext, AutomaticIndexingStrategyStartContext startContext, HibernateOrmListenerContextProvider contextProvider) {
        this.mappingContext = mappingContext;
        ConfigurationPropertySource configurationSource = startContext.configurationPropertySource();
        this.defaultSynchronizationStrategyHolder = (BeanHolder)AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY.getAndTransform(configurationSource, referenceOptional -> {
            if (this.usesEventQueue()) {
                if (referenceOptional.isPresent()) {
                    throw log.cannotConfigureSynchronizationStrategyWithIndexingEventQueue();
                }
                return BeanHolder.of((Object)AutomaticIndexingSynchronizationStrategy.writeSync());
            }
            return startContext.beanResolver().resolve(referenceOptional.orElse(HibernateOrmMapperSettings.Defaults.AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY));
        });
        this.defaultSynchronizationStrategy = this.configure((AutomaticIndexingSynchronizationStrategy)this.defaultSynchronizationStrategyHolder.get());
        if (((Boolean)AUTOMATIC_INDEXING_ENABLED.get(configurationSource)).booleanValue() && AUTOMATIC_INDEXING_ENABLED_LEGACY_STRATEGY.getAndMap(configurationSource, enabled -> {
            log.automaticIndexingStrategyIsDeprecated(AUTOMATIC_INDEXING_ENABLED_LEGACY_STRATEGY.resolveOrRaw(configurationSource), AUTOMATIC_INDEXING_ENABLED.resolveOrRaw(configurationSource));
            return enabled;
        }).orElse(true).booleanValue()) {
            log.debug("Hibernate Search event listeners activated");
            HibernateSearchEventListener hibernateSearchEventListener = new HibernateSearchEventListener(contextProvider, (Boolean)DIRTY_CHECK_ENABLED.get(startContext.configurationPropertySource()));
            hibernateSearchEventListener.registerTo(mappingContext.sessionFactory());
        } else {
            log.debug("Hibernate Search event listeners deactivated");
        }
    }

    public void stop() {
        try (Closer closer = new Closer();){
            closer.push(BeanHolder::close, this.defaultSynchronizationStrategyHolder);
            this.defaultSynchronizationStrategy = null;
            this.defaultSynchronizationStrategyHolder = null;
            this.mappingContext = null;
        }
    }

    public ConfiguredAutomaticIndexingSynchronizationStrategy defaultIndexingPlanSynchronizationStrategy() {
        return this.defaultSynchronizationStrategy;
    }

    public ConfiguredAutomaticIndexingSynchronizationStrategy configureOverriddenSynchronizationStrategy(AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        if (this.usesEventQueue()) {
            throw log.cannotConfigureSynchronizationStrategyWithIndexingEventQueue();
        }
        ConfiguredAutomaticIndexingSynchronizationStrategy.Builder builder = new ConfiguredAutomaticIndexingSynchronizationStrategy.Builder(this.mappingContext.failureHandler(), this.mappingContext.entityReferenceFactory());
        synchronizationStrategy.apply(builder);
        return builder.build();
    }

    public PojoIndexingPlan createIndexingPlan(HibernateOrmSearchSession context, ConfiguredAutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        if (this.usesEventQueue()) {
            AutomaticIndexingQueueEventSendingPlan delegate = this.senderFactory.apply(context);
            return this.mappingContext.createIndexingPlan((PojoWorkSessionContext)context, new HibernateOrmIndexingQueueEventSendingPlan(delegate));
        }
        return this.mappingContext.createIndexingPlan((PojoWorkSessionContext)context, synchronizationStrategy.getDocumentCommitStrategy(), synchronizationStrategy.getDocumentRefreshStrategy());
    }

    public Synchronization createTransactionWorkQueueSynchronization(PojoIndexingPlan indexingPlan, HibernateOrmSearchSessionHolder sessionProperties, Transaction transactionIdentifier, ConfiguredAutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        if (this.enlistsInTransaction) {
            return new BeforeCommitIndexingPlanSynchronization(indexingPlan, sessionProperties, transactionIdentifier, synchronizationStrategy);
        }
        return new AfterCommitIndexingPlanSynchronization(indexingPlan, sessionProperties, transactionIdentifier, synchronizationStrategy);
    }

    public PojoIndexingQueueEventProcessingPlan createIndexingQueueEventProcessingPlan(HibernateOrmSearchSession context, ConfiguredAutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        AutomaticIndexingQueueEventSendingPlan delegate = this.senderFactory.apply(context);
        return this.mappingContext.createIndexingQueueEventProcessingPlan((PojoWorkSessionContext)context, synchronizationStrategy.getDocumentCommitStrategy(), synchronizationStrategy.getDocumentRefreshStrategy(), new HibernateOrmIndexingQueueEventSendingPlan(delegate));
    }

    private ConfiguredAutomaticIndexingSynchronizationStrategy configure(AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        ConfiguredAutomaticIndexingSynchronizationStrategy.Builder builder = new ConfiguredAutomaticIndexingSynchronizationStrategy.Builder(this.mappingContext.failureHandler(), this.mappingContext.entityReferenceFactory());
        synchronizationStrategy.apply(builder);
        return builder.build();
    }
}

