/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.function.Consumer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class SecurityActions {
    private static final Log log = LogFactory.getLog(SecurityActions.class);

    SecurityActions() {
    }

    static Method getMethodAndSetAccessible(Object o, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return SecurityActions.getMethodAndSetAccessible(o.getClass(), methodName, parameterTypes);
    }

    static Method getMethodAndSetAccessible(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
        SecurityActions.doPrivileged(() -> method.setAccessible(true), e -> log.unableToSetAccessible(method, (Exception)e));
        return method;
    }

    private static void doPrivileged(Runnable privilegedAction, Consumer<Exception> exceptionHandler) {
        try {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(() -> {
                    privilegedAction.run();
                    return null;
                });
            } else {
                privilegedAction.run();
            }
        }
        catch (Exception e) {
            exceptionHandler.accept(e);
        }
    }
}

