/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.interceptors;

import java.lang.reflect.Method;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EJBComponentUnavailableException;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.msc.service.ServiceName;

public class LoggingInterceptor
implements Interceptor {
    public static final ServiceName LOGGING_ENABLED_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "logging", "enabled"});
    public static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)new LoggingInterceptor());

    private LoggingInterceptor() {
    }

    public Object processInvocation(InterceptorContext interceptorContext) throws Exception {
        EJBComponent component = (EJBComponent)((Object)interceptorContext.getPrivateData(Component.class));
        if (!component.isExceptionLoggingEnabled()) {
            return interceptorContext.proceed();
        }
        try {
            return interceptorContext.proceed();
        }
        catch (EJBComponentUnavailableException ex) {
            if (EjbLogger.EJB3_INVOCATION_LOGGER.isTraceEnabled()) {
                EjbLogger.EJB3_INVOCATION_LOGGER.trace(ex.getMessage());
            }
            throw ex;
        }
        catch (Throwable t) {
            Method invokedMethod = interceptorContext.getMethod();
            ApplicationExceptionDetails appException = component.getApplicationException(t.getClass(), invokedMethod);
            if (appException == null) {
                EjbLogger.EJB3_INVOCATION_LOGGER.invocationFailed(component.getComponentName(), invokedMethod, t);
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
    }
}

