/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.Test;

public class AmqpReceiverDrainTest
extends AmqpClientTestSupport {
    @Test(timeout=60000L)
    public void testReceiverCanDrainMessagesQueue() throws Exception {
        this.doTestReceiverCanDrainMessages(false);
    }

    @Test(timeout=60000L)
    public void testReceiverCanDrainMessagesTopic() throws Exception {
        this.doTestReceiverCanDrainMessages(true);
    }

    private void doTestReceiverCanDrainMessages(boolean topic) throws Exception {
        String destinationName = topic ? this.getTopicName() : this.getQueueName();
        int MSG_COUNT = 20;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(destinationName);
        this.sendMessages(destinationName, MSG_COUNT);
        Queue queueView = this.getProxyToQueue(destinationName);
        Wait.assertEquals((long)MSG_COUNT, () -> ((Queue)queueView).getMessageCount());
        Wait.assertEquals((int)0, () -> ((Queue)queueView).getDeliveringCount());
        receiver.drain(MSG_COUNT);
        for (int i = 0; i < MSG_COUNT; ++i) {
            AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
            AmqpReceiverDrainTest.assertNotNull((String)("Failed to read message: " + (i + 1)), (Object)message);
            this.instanceLog.info((Object)("Read message: " + message.getMessageId()));
            message.accept();
        }
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testPullWithNoMessageGetDrainedQueue() throws Exception {
        this.doTestPullWithNoMessageGetDrained(false);
    }

    @Test(timeout=60000L)
    public void testPullWithNoMessageGetDrainedTopic() throws Exception {
        this.doTestPullWithNoMessageGetDrained(true);
    }

    private void doTestPullWithNoMessageGetDrained(boolean topic) throws Exception {
        String destinationName = topic ? this.getTopicName() : this.getQueueName();
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(destinationName);
        receiver.flow(10);
        Queue queueView = this.getProxyToQueue(destinationName);
        AmqpReceiverDrainTest.assertEquals((long)0L, (long)queueView.getMessageCount());
        AmqpReceiverDrainTest.assertEquals((long)0L, (long)queueView.getMessagesAcknowledged());
        AmqpReceiverDrainTest.assertEquals((long)10L, (long)receiver.getReceiver().getRemoteCredit());
        AmqpReceiverDrainTest.assertNull((Object)receiver.pull(1L, TimeUnit.SECONDS));
        AmqpReceiverDrainTest.assertEquals((long)0L, (long)receiver.getReceiver().getRemoteCredit());
        connection.close();
    }

    @Test(timeout=60000L)
    public void testPullOneFromRemoteQueue() throws Exception {
        this.doTestPullOneFromRemote(false);
    }

    @Test(timeout=60000L)
    public void testPullOneFromRemoteTopic() throws Exception {
        this.doTestPullOneFromRemote(true);
    }

    private void doTestPullOneFromRemote(boolean topic) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String destinationName = topic ? this.getTopicName() : this.getQueueName();
        AmqpReceiver receiver = session.createReceiver(destinationName);
        int MSG_COUNT = 20;
        this.sendMessages(destinationName, MSG_COUNT);
        Queue queueView = this.getProxyToQueue(destinationName);
        AmqpReceiverDrainTest.assertEquals((long)MSG_COUNT, (long)queueView.getMessageCount());
        AmqpReceiverDrainTest.assertEquals((long)0L, (long)queueView.getDeliveringCount());
        AmqpReceiverDrainTest.assertEquals((long)0L, (long)receiver.getReceiver().getRemoteCredit());
        AmqpMessage message = receiver.pull(5L, TimeUnit.SECONDS);
        AmqpReceiverDrainTest.assertNotNull((Object)message);
        message.accept();
        AmqpReceiverDrainTest.assertEquals((long)0L, (long)receiver.getReceiver().getRemoteCredit());
        receiver.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testMultipleZeroResultPullsQueue() throws Exception {
        this.doTestMultipleZeroResultPulls(false);
    }

    @Test(timeout=60000L)
    public void testMultipleZeroResultPullsTopic() throws Exception {
        this.doTestMultipleZeroResultPulls(true);
    }

    private void doTestMultipleZeroResultPulls(boolean topic) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String destinationName = topic ? this.getTopicName() : this.getQueueName();
        AmqpReceiver receiver = session.createReceiver(destinationName);
        receiver.flow(10);
        Queue queueView = this.getProxyToQueue(destinationName);
        AmqpReceiverDrainTest.assertEquals((long)0L, (long)queueView.getMessageCount());
        AmqpReceiverDrainTest.assertEquals((long)0L, (long)queueView.getDeliveringCount());
        AmqpReceiverDrainTest.assertEquals((long)10L, (long)receiver.getReceiver().getRemoteCredit());
        AmqpReceiverDrainTest.assertNull((Object)receiver.pull(1L, TimeUnit.SECONDS));
        AmqpReceiverDrainTest.assertEquals((long)0L, (long)receiver.getReceiver().getRemoteCredit());
        AmqpReceiverDrainTest.assertNull((Object)receiver.pull(1L, TimeUnit.SECONDS));
        AmqpReceiverDrainTest.assertNull((Object)receiver.pull(1L, TimeUnit.SECONDS));
        AmqpReceiverDrainTest.assertEquals((long)0L, (long)receiver.getReceiver().getRemoteCredit());
        connection.close();
    }
}

