/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.server.protocol.http.ALPNBannedCiphers;
import io.undertow.server.protocol.http.ALPNOfferedClientHelloExplorer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;

public class ALPNLimitingSSLEngine
extends SSLEngine {
    private static final SSLEngineResult UNDERFLOW_RESULT = new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private final SSLEngine delegate;
    private final Runnable invalidAlpnRunnable;
    private boolean done;

    public ALPNLimitingSSLEngine(SSLEngine delegate, Runnable invalidAlpnRunnable) {
        this.delegate = delegate;
        this.invalidAlpnRunnable = invalidAlpnRunnable;
    }

    @Override
    public String getPeerHost() {
        return this.delegate.getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return this.delegate.getPeerPort();
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        return this.delegate.wrap(src, dst);
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, ByteBuffer dst) throws SSLException {
        return this.wrap(srcs, 0, srcs.length, dst);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        if (this.done) {
            return this.delegate.unwrap(src, dst);
        }
        if (ALPNOfferedClientHelloExplorer.isIncompleteHeader(src)) {
            return UNDERFLOW_RESULT;
        }
        try {
            List<Integer> clientCiphers = ALPNOfferedClientHelloExplorer.parseClientHello(src);
            if (clientCiphers != null) {
                this.limitCiphers(clientCiphers);
                this.done = true;
            } else {
                this.done = true;
            }
        }
        catch (BufferUnderflowException e) {
            return UNDERFLOW_RESULT;
        }
        return this.delegate.unwrap(src, dst);
    }

    private void limitCiphers(List<Integer> clientCiphers) {
        boolean clientIsCompliant = false;
        for (int cipher : clientCiphers) {
            if (cipher != 49199) continue;
            clientIsCompliant = true;
        }
        if (!clientIsCompliant) {
            this.invalidAlpnRunnable.run();
        } else {
            ArrayList<String> ciphers = new ArrayList<String>();
            for (String cipher : this.delegate.getEnabledCipherSuites()) {
                if (!ALPNBannedCiphers.isAllowed(cipher)) continue;
                ciphers.add(cipher);
            }
            this.delegate.setEnabledCipherSuites(ciphers.toArray(new String[ciphers.size()]));
        }
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts) throws SSLException {
        return this.unwrap(src, dsts, 0, dsts.length);
    }

    @Override
    public SSLSession getHandshakeSession() {
        return this.delegate.getHandshakeSession();
    }

    @Override
    public SSLParameters getSSLParameters() {
        return this.delegate.getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters sslParameters) {
        this.delegate.setSSLParameters(sslParameters);
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, int off, int len, ByteBuffer dst) throws SSLException {
        return this.delegate.wrap(srcs, off, len, dst);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBuffers, int i, int i1) throws SSLException {
        if (this.done) {
            return this.delegate.unwrap(byteBuffer, byteBuffers, i, i1);
        }
        if (ALPNOfferedClientHelloExplorer.isIncompleteHeader(byteBuffer)) {
            return UNDERFLOW_RESULT;
        }
        try {
            List<Integer> clientCiphers = ALPNOfferedClientHelloExplorer.parseClientHello(byteBuffer);
            if (clientCiphers != null) {
                this.limitCiphers(clientCiphers);
                this.done = true;
            } else {
                this.done = true;
            }
        }
        catch (BufferUnderflowException e) {
            return UNDERFLOW_RESULT;
        }
        return this.delegate.unwrap(byteBuffer, byteBuffers, i, i1);
    }

    @Override
    public Runnable getDelegatedTask() {
        return this.delegate.getDelegatedTask();
    }

    @Override
    public void closeInbound() throws SSLException {
        this.delegate.closeInbound();
    }

    @Override
    public boolean isInboundDone() {
        return this.delegate.isInboundDone();
    }

    @Override
    public void closeOutbound() {
        this.delegate.closeOutbound();
    }

    @Override
    public boolean isOutboundDone() {
        return this.delegate.isOutboundDone();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.delegate.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] strings) {
        this.delegate.setEnabledCipherSuites(strings);
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.delegate.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.delegate.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] strings) {
        this.delegate.setEnabledProtocols(strings);
    }

    @Override
    public SSLSession getSession() {
        return this.delegate.getSession();
    }

    @Override
    public void beginHandshake() throws SSLException {
        this.delegate.beginHandshake();
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.delegate.getHandshakeStatus();
    }

    @Override
    public void setUseClientMode(boolean b) {
        if (b) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean getUseClientMode() {
        return this.delegate.getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean b) {
        this.delegate.setNeedClientAuth(b);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.delegate.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean b) {
        this.delegate.setWantClientAuth(b);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.delegate.getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean b) {
        this.delegate.setEnableSessionCreation(b);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.delegate.getEnableSessionCreation();
    }
}

