/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.compression;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.sshd.common.compression.BaseCompression;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.util.buffer.Buffer;

public class CompressionZlib
extends BaseCompression {
    private static final int BUF_SIZE = 4096;
    private byte[] tmpbuf = new byte[4096];
    private Deflater compresser;
    private Inflater decompresser;

    public CompressionZlib() {
        this("zlib");
    }

    protected CompressionZlib(String name) {
        super(name);
    }

    @Override
    public boolean isDelayed() {
        return false;
    }

    @Override
    public void init(Compression.Type type, int level) {
        this.compresser = new Deflater(level);
        this.decompresser = new Inflater();
    }

    @Override
    public void compress(Buffer buffer) throws IOException {
        this.compresser.setInput(buffer.array(), buffer.rpos(), buffer.available());
        buffer.wpos(buffer.rpos());
        int len = this.compresser.deflate(this.tmpbuf, 0, this.tmpbuf.length, 2);
        while (len > 0) {
            buffer.putRawBytes(this.tmpbuf, 0, len);
            len = this.compresser.deflate(this.tmpbuf, 0, this.tmpbuf.length, 2);
        }
    }

    @Override
    public void uncompress(Buffer from, Buffer to) throws IOException {
        this.decompresser.setInput(from.array(), from.rpos(), from.available());
        try {
            int len = this.decompresser.inflate(this.tmpbuf);
            while (len > 0) {
                to.putRawBytes(this.tmpbuf, 0, len);
                len = this.decompresser.inflate(this.tmpbuf);
            }
        }
        catch (DataFormatException e) {
            throw new IOException("Error decompressing data", e);
        }
    }
}

