/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.metadata.property;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import org.jboss.as.ee.metadata.property.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.metadata.property.CompositePropertyResolver;
import org.jboss.metadata.property.PropertiesPropertyResolver;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;
import org.jboss.metadata.property.SimpleExpressionResolver;
import org.jboss.metadata.property.SystemPropertyResolver;

public class DeploymentPropertyResolverProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit;
        DeploymentUnit current = deploymentUnit = phaseContext.getDeploymentUnit();
        ArrayList<Object> propertyResolvers = new ArrayList<Object>();
        List functions = (List)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_EXPRESSION_RESOLVERS);
        if (functions != null) {
            for (Function funct : functions) {
                propertyResolvers.add(expressionContent -> {
                    String input = "${" + expressionContent + "}";
                    String resolved = (String)funct.apply(input);
                    return resolved == null ? null : new SimpleExpressionResolver.ResolutionResult(resolved, false);
                });
            }
        }
        do {
            Properties deploymentProperties;
            if ((deploymentProperties = (Properties)current.getAttachment(Attachments.DEPLOYMENT_PROPERTIES)) == null) continue;
            propertyResolvers.add(new PropertiesPropertyResolver(deploymentProperties));
        } while ((current = current.getParent()) != null);
        propertyResolvers.add(SystemPropertyResolver.INSTANCE);
        PropertyReplacer propertyReplacer = PropertyReplacers.resolvingExpressionReplacer((SimpleExpressionResolver)new CompositePropertyResolver((SimpleExpressionResolver[])propertyResolvers.toArray(SimpleExpressionResolver[]::new)));
        deploymentUnit.putAttachment(Attachments.FINAL_PROPERTY_REPLACER, (Object)propertyReplacer);
    }
}

