/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sike;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.pqc.crypto.sike.SIKEEngine;
import org.bouncycastle.pqc.crypto.sike.SIKEKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.sike.SIKEPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.sike.SIKEPublicKeyParameters;

public class SIKEKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SIKEKeyGenerationParameters sikeParams;
    private SecureRandom random;

    private void initialize(KeyGenerationParameters keyGenerationParameters) {
        this.sikeParams = (SIKEKeyGenerationParameters)keyGenerationParameters;
        this.random = keyGenerationParameters.getRandom();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        System.err.println("WARNING: the SIKE algorithm is only for research purposes, insecure");
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("SIKEKeyGen", 0, this.sikeParams.getParameters(), CryptoServicePurpose.KEYGEN));
        SIKEEngine sIKEEngine = this.sikeParams.getParameters().getEngine();
        byte[] byArray = new byte[sIKEEngine.getPrivateKeySize()];
        byte[] byArray2 = new byte[sIKEEngine.getPublicKeySize()];
        sIKEEngine.crypto_kem_keypair(byArray2, byArray, this.random);
        SIKEPublicKeyParameters sIKEPublicKeyParameters = new SIKEPublicKeyParameters(this.sikeParams.getParameters(), byArray2);
        SIKEPrivateKeyParameters sIKEPrivateKeyParameters = new SIKEPrivateKeyParameters(this.sikeParams.getParameters(), byArray);
        return new AsymmetricCipherKeyPair(sIKEPublicKeyParameters, sIKEPrivateKeyParameters);
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

