/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons;

import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.hibernate.engine.jndi.internal.JndiServiceInitiator;
import org.hibernate.engine.jndi.spi.JndiService;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.spi.EmbeddedCacheManagerProvider;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.AbstractDelegatingEmbeddedCacheManager;

public class JndiCacheManagerProvider
implements EmbeddedCacheManagerProvider {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(JndiCacheManagerProvider.class);

    public EmbeddedCacheManager getEmbeddedCacheManager(Properties properties) {
        String jndiManagerName = properties.getProperty("hibernate.cache.infinispan.cachemanager");
        if (jndiManagerName != null) {
            EmbeddedCacheManager cacheManager = this.locateCacheManager(jndiManagerName, properties);
            return new AbstractDelegatingEmbeddedCacheManager(cacheManager){

                public void stop() {
                }

                public void close() {
                }
            };
        }
        String factoryClass = properties.getProperty("hibernate.cache.region.factory_class");
        if (factoryClass == null) {
            return null;
        }
        if (factoryClass.endsWith("JndiInfinispanRegionFactory") || factoryClass.equals("infinispan-jndi")) {
            throw log.propertyCacheManagerResourceNotSet();
        }
        return null;
    }

    private EmbeddedCacheManager locateCacheManager(String jndiNamespace, Properties jndiProperties) {
        JndiService jndiService = JndiServiceInitiator.INSTANCE.initiateService(jndiProperties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), Map.Entry::getValue)), null);
        return (EmbeddedCacheManager)jndiService.locate(jndiNamespace);
    }
}

