/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import jakarta.jms.JMSException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.LocalTransaction;
import org.jboss.resource.adapter.jms.JmsManagedConnection;

public class JmsLocalTransaction
implements LocalTransaction {
    protected JmsManagedConnection mc;

    public JmsLocalTransaction(JmsManagedConnection mc) {
        this.mc = mc;
    }

    public void begin() throws ResourceException {
    }

    public void commit() throws ResourceException {
        this.mc.lock();
        try {
            if (this.mc.getSession().getTransacted()) {
                this.mc.getSession().commit();
            }
        }
        catch (JMSException e) {
            throw new ResourceException("Could not commit LocalTransaction", (Throwable)e);
        }
        finally {
            this.mc.unlock();
        }
    }

    public void rollback() throws ResourceException {
        this.mc.lock();
        try {
            if (this.mc.getSession().getTransacted()) {
                this.mc.getSession().rollback();
            }
        }
        catch (JMSException ex) {
            throw new ResourceException("Could not rollback LocalTransaction", (Throwable)ex);
        }
        finally {
            this.mc.unlock();
        }
    }
}

