/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.ProducerField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ProducerFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerProducer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.utils.JsonLoader;

public class ProducerView
extends ActiveMQAbstractView<ServerProducer> {
    private static final String defaultSortColumn = ProducerField.CREATION_TIME.getName();
    private final ActiveMQServer server;

    public ProducerView(ActiveMQServer server) {
        this.server = server;
        this.predicate = new ProducerFilterPredicate(server);
    }

    @Override
    public Class getClassT() {
        return ServerProducer.class;
    }

    @Override
    public JsonObjectBuilder toJson(ServerProducer producer) {
        ServerSession session = this.server.getSessionByID(producer.getSessionID());
        if (session == null) {
            return null;
        }
        String sessionClientID = session.getRemotingConnection().getClientID();
        if (sessionClientID == null && session.getMetaData("jms-session") != null) {
            sessionClientID = session.getMetaData("jms-client-id");
        }
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add(ProducerField.ID.getName(), this.toString(producer.getID())).add(ProducerField.SESSION.getName(), this.toString(session.getName())).add(ProducerField.CLIENT_ID.getName(), this.toString(sessionClientID)).add(ProducerField.USER.getName(), this.toString(session.getUsername())).add(ProducerField.VALIDATED_USER.getName(), this.toString(session.getValidatedUser())).add(ProducerField.PROTOCOL.getName(), this.toString(session.getRemotingConnection().getProtocolName())).add(ProducerField.ADDRESS.getName(), this.toString(producer.getAddress() != null ? producer.getAddress() : session.getDefaultAddress())).add(ProducerField.LOCAL_ADDRESS.getName(), this.toString(session.getRemotingConnection().getTransportConnection().getLocalAddress())).add(ProducerField.REMOTE_ADDRESS.getName(), this.toString(session.getRemotingConnection().getTransportConnection().getRemoteAddress())).add(ProducerField.CREATION_TIME.getName(), this.toString(producer.getCreationTime()));
        return obj;
    }

    @Override
    public Object getField(ServerProducer producer, String fieldName) {
        ServerSession session = this.server.getSessionByID(producer.getSessionID());
        if (session == null) {
            return null;
        }
        ProducerField field = ProducerField.valueOfName(fieldName);
        switch (field) {
            case ID: {
                return producer.getID();
            }
            case SESSION: {
                return session.getName();
            }
            case USER: {
                return session.getUsername();
            }
            case VALIDATED_USER: {
                return session.getValidatedUser();
            }
            case CLIENT_ID: {
                return session.getRemotingConnection().getClientID();
            }
            case PROTOCOL: {
                return session.getRemotingConnection().getProtocolName();
            }
            case ADDRESS: {
                return producer.getAddress() != null ? producer.getAddress() : session.getDefaultAddress();
            }
            case LOCAL_ADDRESS: {
                return session.getRemotingConnection().getTransportConnection().getLocalAddress();
            }
            case REMOTE_ADDRESS: {
                return session.getRemotingConnection().getTransportConnection().getRemoteAddress();
            }
            case CREATION_TIME: {
                return producer.getCreationTime();
            }
        }
        throw new IllegalArgumentException("Unsupported field, " + fieldName);
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

