/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.utils.BufferHelper;
import org.apache.activemq.artemis.utils.Preconditions;

public class PersistedRole
implements EncodingSupport {
    private long storeId;
    private String username;
    private List<String> roles;

    public PersistedRole() {
    }

    public PersistedRole(String username, List<String> roles) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkNotNull(roles);
        this.username = username;
        this.roles = roles;
    }

    public void setStoreId(long id) {
        this.storeId = id;
    }

    public long getStoreId() {
        return this.storeId;
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public int getEncodeSize() {
        int size = 0;
        size += BufferHelper.sizeOfString((String)this.username);
        size += 4;
        for (String role : this.roles) {
            size += BufferHelper.sizeOfString((String)role);
        }
        return size;
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeString(this.username);
        buffer.writeInt(this.roles.size());
        for (String user : this.roles) {
            buffer.writeString(user);
        }
    }

    public void decode(ActiveMQBuffer buffer) {
        this.username = buffer.readString();
        this.roles = new ArrayList<String>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.roles.add(buffer.readString());
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("PersistedRole [storeId=").append(this.storeId);
        result.append(", username=").append(this.username);
        result.append(", roles [");
        if (this.roles != null) {
            for (int i = 0; i < this.roles.size(); ++i) {
                result.append(this.roles.get(i));
                if (i >= this.roles.size() - 1) continue;
                result.append(", ");
            }
        }
        result.append("]]");
        return result.toString();
    }
}

