/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.security.ActiveMQBasicSecurityManager;

public class BasicAuthenticator
implements JMXAuthenticator {
    ActiveMQBasicSecurityManager securityManager;

    public BasicAuthenticator(ActiveMQBasicSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    @Override
    public Subject authenticate(Object credentials) throws SecurityException {
        Subject result;
        String[] params = null;
        if (credentials instanceof String[] && ((String[])credentials).length == 2) {
            params = (String[])credentials;
        }
        if ((result = this.securityManager.authenticate((String)params[0], params[1], null, null)) != null) {
            if (AuditLogger.isResourceLoggingEnabled()) {
                AuditLogger.userSuccesfullyAuthenticatedInAudit((Subject)result);
            }
            return result;
        }
        if (AuditLogger.isResourceLoggingEnabled()) {
            AuditLogger.userFailedAuthenticationInAudit((Subject)result, null);
        }
        throw new SecurityException("Authentication failed");
    }
}

