/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.weld.ejb.BusinessInterfaceDescriptorImpl;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.resources.spi.ResourceLoader;

public class EjbDescriptorImpl<T>
implements EjbDescriptor<T> {
    private final ServiceName baseName;
    private final Set<BusinessInterfaceDescriptor<?>> localInterfaces;
    private final Set<BusinessInterfaceDescriptor<?>> remoteInterfaces;
    private final Map<Class<?>, ServiceName> viewServices;
    private final Set<Method> removeMethods;
    private final Class<T> ejbClass;
    private final String ejbName;
    private final boolean stateless;
    private final boolean stateful;
    private final boolean singleton;
    private final boolean messageDriven;
    private final boolean passivationCapable;

    public EjbDescriptorImpl(EJBComponentDescription componentDescription, BeanDeploymentArchive beanDeploymentArchive, DeploymentReflectionIndex reflectionIndex) {
        SessionBeanComponentDescription description = componentDescription instanceof SessionBeanComponentDescription ? (SessionBeanComponentDescription)componentDescription : null;
        HashSet localInterfaces = new HashSet();
        HashSet remoteInterfaces = new HashSet();
        ResourceLoader loader = (ResourceLoader)beanDeploymentArchive.getServices().get(ResourceLoader.class);
        this.ejbClass = loader.classForName(componentDescription.getEJBClassName());
        if (componentDescription.getViews() != null) {
            for (ViewDescription view : componentDescription.getViews()) {
                if (description == null || this.getMethodIntf(view) == MethodInterfaceType.Local) {
                    String viewClassName = view.getViewClassName();
                    localInterfaces.add(new BusinessInterfaceDescriptorImpl(beanDeploymentArchive, viewClassName));
                    continue;
                }
                if (this.getMethodIntf(view) != MethodInterfaceType.Remote) continue;
                remoteInterfaces.add(new BusinessInterfaceDescriptorImpl(beanDeploymentArchive, view.getViewClassName()));
            }
        }
        if (componentDescription instanceof StatefulComponentDescription) {
            HashSet<Method> removeMethods = new HashSet<Method>();
            Collection methods = ((StatefulComponentDescription)componentDescription).getRemoveMethods();
            for (StatefulComponentDescription.StatefulRemoveMethod statefulRemoveMethod : methods) {
                for (Class<T> c = this.ejbClass; c != null && c != Object.class; c = c.getSuperclass()) {
                    ClassReflectionIndex index = reflectionIndex.getClassIndex(c);
                    Method m = index.getMethod(statefulRemoveMethod.getMethodIdentifier());
                    if (m == null) continue;
                    removeMethods.add(m);
                }
            }
            this.removeMethods = Collections.unmodifiableSet(removeMethods);
        } else {
            this.removeMethods = Collections.emptySet();
        }
        this.ejbName = componentDescription.getEJBName();
        this.localInterfaces = localInterfaces;
        this.remoteInterfaces = remoteInterfaces;
        this.baseName = componentDescription.getServiceName();
        this.stateless = componentDescription.isStateless();
        this.messageDriven = componentDescription.isMessageDriven();
        this.stateful = componentDescription.isStateful();
        this.singleton = componentDescription.isSingleton();
        this.passivationCapable = componentDescription.isPassivationApplicable();
        HashMap viewServices = new HashMap();
        HashMap<Class, ServiceName> viewServicesMap = new HashMap<Class, ServiceName>();
        for (ViewDescription viewDescription : componentDescription.getViews()) {
            viewServicesMap.put(loader.classForName(viewDescription.getViewClassName()), viewDescription.getServiceName());
        }
        for (Map.Entry entry : viewServicesMap.entrySet()) {
            Class viewClass = (Class)entry.getKey();
            if (viewClass == null) continue;
            HashSet<Class> seen = new HashSet<Class>();
            HashSet toProcess = new HashSet();
            toProcess.add(viewClass);
            while (!toProcess.isEmpty()) {
                Iterator it = toProcess.iterator();
                Class clazz = (Class)it.next();
                it.remove();
                seen.add(clazz);
                viewServices.put(clazz, (ServiceName)entry.getValue());
                Class superclass = clazz.getSuperclass();
                if (superclass != Object.class && superclass != null && !seen.contains(superclass)) {
                    toProcess.add(superclass);
                }
                for (Class<?> iface : clazz.getInterfaces()) {
                    if (seen.contains(iface)) continue;
                    toProcess.add(iface);
                }
            }
        }
        this.viewServices = viewServices;
    }

    private MethodInterfaceType getMethodIntf(ViewDescription view) {
        if (view instanceof EJBViewDescription) {
            EJBViewDescription ejbView = (EJBViewDescription)view;
            return ejbView.getMethodIntf();
        }
        return null;
    }

    public Class<T> getBeanClass() {
        return this.ejbClass;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getLocalBusinessInterfaces() {
        return this.localInterfaces;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getRemoteBusinessInterfaces() {
        return this.remoteInterfaces;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public Collection<Method> getRemoveMethods() {
        return this.removeMethods;
    }

    public boolean isStateless() {
        return this.stateless;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public boolean isMessageDriven() {
        return this.messageDriven;
    }

    public ServiceName getBaseName() {
        return this.baseName;
    }

    public ServiceName getCreateServiceName() {
        return this.baseName.append(new String[]{"CREATE"});
    }

    public ServiceName getStartServiceName() {
        return this.baseName.append(new String[]{"START"});
    }

    public Map<Class<?>, ServiceName> getViewServices() {
        return this.viewServices;
    }

    public boolean isPassivationCapable() {
        return this.passivationCapable;
    }
}

