/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.util;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.util.SecurityActions;
import org.wildfly.common.Assert;
import org.wildfly.security.manager.WildFlySecurityManager;

public class Injection {
    public void inject(Object object, String propertyName, Object propertyValue) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.inject(object, propertyName, propertyValue, null, false);
    }

    public void inject(Object object, String propertyName, Object propertyValue, String propertyType) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.inject(object, propertyName, propertyValue, propertyType, false);
    }

    public void inject(Object object, String propertyName, Object propertyValue, String propertyType, boolean includeFields) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        Assert.checkNotNullParam((String)"object", (Object)object);
        if (propertyName == null || propertyName.trim().equals("")) {
            throw ConnectorLogger.ROOT_LOGGER.undefinedVar("PropertyName");
        }
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase(Locale.US);
        if (propertyName.length() > 1) {
            methodName = methodName + propertyName.substring(1);
        }
        if ((method = this.findMethod(object.getClass(), methodName, propertyType)) != null) {
            Class<?> parameterClass = method.getParameterTypes()[0];
            Object parameterValue = null;
            try {
                parameterValue = this.getValue(propertyName, parameterClass, propertyValue, WildFlySecurityManager.getClassLoaderPrivileged(object.getClass()));
            }
            catch (Throwable t) {
                throw new InvocationTargetException(t, t.getMessage());
            }
            if (!parameterClass.isPrimitive() || parameterValue != null) {
                method.invoke(object, parameterValue);
            }
        } else {
            if (!includeFields) {
                throw ConnectorLogger.ROOT_LOGGER.noSuchMethod(methodName);
            }
            Field field = this.findField(object.getClass(), propertyName, propertyType);
            if (field != null) {
                Class<?> fieldClass = field.getType();
                Object fieldValue = null;
                try {
                    fieldValue = this.getValue(propertyName, fieldClass, propertyValue, WildFlySecurityManager.getClassLoaderPrivileged(object.getClass()));
                }
                catch (Throwable t) {
                    throw new InvocationTargetException(t, t.getMessage());
                }
                field.set(object, fieldValue);
            } else {
                throw ConnectorLogger.ROOT_LOGGER.noSuchField(propertyName);
            }
        }
    }

    private boolean argumentMatches(String classType, String propertyType) {
        return classType.equals(propertyType) || classType.equals("java.lang.Byte") && propertyType.equals("byte") || classType.equals("java.lang.Short") && propertyType.equals("short") || classType.equals("java.lang.Integer") && propertyType.equals("int") || classType.equals("java.lang.Long") && propertyType.equals("long") || classType.equals("java.lang.Float") && propertyType.equals("float") || classType.equals("java.lang.Double") && propertyType.equals("double") || classType.equals("java.lang.Boolean") && propertyType.equals("boolean") || classType.equals("java.lang.Character") && propertyType.equals("char");
    }

    protected Method findMethod(Class<?> clz, String methodName, String propertyType) {
        while (!clz.equals(Object.class)) {
            ArrayList<Method> hits = null;
            Method[] methods = SecurityActions.getDeclaredMethods(clz);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!methodName.equals(method.getName()) || method.getParameterCount() != 1 || propertyType != null && !this.argumentMatches(propertyType, method.getParameterTypes()[0].getName())) continue;
                if (hits == null) {
                    hits = new ArrayList<Method>(1);
                }
                SecurityActions.setAccessible(method);
                hits.add(method);
            }
            if (hits != null) {
                if (hits.size() == 1) {
                    return (Method)hits.get(0);
                }
                Collections.sort(hits, new MethodSorter());
                if (propertyType != null) {
                    for (Method m : hits) {
                        if (!propertyType.equals(m.getParameterTypes()[0].getName())) continue;
                        return m;
                    }
                }
                return (Method)hits.get(0);
            }
            clz = clz.getSuperclass();
        }
        return null;
    }

    protected Field findField(Class<?> clz, String fieldName, String fieldType) {
        while (!clz.equals(Object.class)) {
            ArrayList<Field> hits = null;
            Field[] fields = SecurityActions.getDeclaredFields(clz);
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!fieldName.equals(field.getName()) || fieldType != null && !this.argumentMatches(fieldType, field.getType().getName())) continue;
                if (hits == null) {
                    hits = new ArrayList<Field>(1);
                }
                SecurityActions.setAccessible(field);
                hits.add(field);
            }
            if (hits != null) {
                if (hits.size() == 1) {
                    return (Field)hits.get(0);
                }
                Collections.sort(hits, new FieldSorter());
                if (fieldType != null) {
                    for (Field f : hits) {
                        if (!fieldType.equals(f.getType().getName())) continue;
                        return f;
                    }
                }
                return (Field)hits.get(0);
            }
            clz = clz.getSuperclass();
        }
        return null;
    }

    protected Object getValue(String name, Class<?> clz, Object v, ClassLoader cl) throws Exception {
        if (v instanceof String) {
            String substituredValue = this.getSubstitutionValue((String)v);
            if (clz.equals(String.class)) {
                v = substituredValue;
            } else if (clz.equals(Byte.TYPE) || clz.equals(Byte.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Byte.valueOf(substituredValue);
                }
            } else if (clz.equals(Short.TYPE) || clz.equals(Short.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Short.valueOf(substituredValue);
                }
            } else if (clz.equals(Integer.TYPE) || clz.equals(Integer.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Integer.valueOf(substituredValue);
                }
            } else if (clz.equals(Long.TYPE) || clz.equals(Long.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Long.valueOf(substituredValue);
                }
            } else if (clz.equals(Float.TYPE) || clz.equals(Float.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Float.valueOf(substituredValue);
                }
            } else if (clz.equals(Double.TYPE) || clz.equals(Double.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Double.valueOf(substituredValue);
                }
            } else if (clz.equals(Boolean.TYPE) || clz.equals(Boolean.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Boolean.valueOf(substituredValue);
                }
            } else if (clz.equals(Character.TYPE) || clz.equals(Character.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Character.valueOf(substituredValue.charAt(0));
                }
            } else if (clz.equals(InetAddress.class)) {
                v = InetAddress.getByName(substituredValue);
            } else if (clz.equals(Class.class)) {
                v = Class.forName(substituredValue, true, cl);
            } else if (clz.equals(Properties.class)) {
                Properties prop = new Properties();
                StringTokenizer st = new StringTokenizer(substituredValue, " ,");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    String key = "";
                    String value = "";
                    int index = token.indexOf("=");
                    if (index != -1) {
                        key = token.substring(0, index);
                        if (token.length() > index + 1) {
                            value = token.substring(index + 1);
                        }
                    } else {
                        key = token;
                    }
                    if ("".equals(key)) continue;
                    prop.setProperty(key, value);
                }
                v = prop;
            } else {
                try {
                    Constructor<?> constructor = SecurityActions.getConstructor(clz, String.class);
                    v = constructor.newInstance(substituredValue);
                }
                catch (Throwable t) {
                    try {
                        Method valueOf = SecurityActions.getMethod(clz, "valueOf", String.class);
                        v = valueOf.invoke(null, substituredValue);
                    }
                    catch (Throwable inner) {
                        throw ConnectorLogger.ROOT_LOGGER.noPropertyResolution(name);
                    }
                }
            }
        }
        return v;
    }

    protected String getSubstitutionValue(String input) {
        if (input == null || ((String)input).trim().equals("")) {
            return input;
        }
        while (((String)input).indexOf("${") != -1) {
            int from = ((String)input).indexOf("${");
            int to = ((String)input).indexOf("}");
            int dv = ((String)input).indexOf(":", from + 2);
            if (dv != -1 && dv > to) {
                dv = -1;
            }
            String systemProperty = "";
            String defaultValue = "";
            if (dv == -1) {
                String s = ((String)input).substring(from + 2, to);
                systemProperty = "/".equals(s) ? File.separator : (":".equals(s) ? File.pathSeparator : WildFlySecurityManager.getSystemPropertiesPrivileged().getProperty(s));
            } else {
                systemProperty = WildFlySecurityManager.getSystemPropertiesPrivileged().getProperty(((String)input).substring(from + 2, dv));
                defaultValue = ((String)input).substring(dv + 1, to);
            }
            String prefix = "";
            String postfix = "";
            if (from != 0) {
                prefix = ((String)input).substring(0, from);
            }
            if (to + 1 < ((String)input).length() - 1) {
                postfix = ((String)input).substring(to + 1);
            }
            if (systemProperty != null && !systemProperty.trim().equals("")) {
                input = prefix + systemProperty + postfix;
                continue;
            }
            if (!defaultValue.trim().equals("")) {
                input = prefix + defaultValue + postfix;
                continue;
            }
            input = prefix + postfix;
        }
        return input;
    }

    static class FieldSorter
    implements Comparator<Field>,
    Serializable {
        private static final long serialVersionUID = 1L;

        FieldSorter() {
        }

        @Override
        public int compare(Field o1, Field o2) {
            int m1 = o1.getModifiers();
            int m2 = o2.getModifiers();
            if (Modifier.isPublic(m1)) {
                return -1;
            }
            if (Modifier.isPublic(m2)) {
                return 1;
            }
            if (Modifier.isProtected(m1)) {
                return -1;
            }
            if (Modifier.isProtected(m2)) {
                return 1;
            }
            if (Modifier.isPrivate(m1)) {
                return -1;
            }
            if (Modifier.isPrivate(m2)) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && o instanceof FieldSorter;
        }

        public int hashCode() {
            return 42;
        }
    }

    static class MethodSorter
    implements Comparator<Method>,
    Serializable {
        private static final long serialVersionUID = 1L;

        MethodSorter() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            int m1 = o1.getModifiers();
            int m2 = o2.getModifiers();
            if (Modifier.isPublic(m1)) {
                return -1;
            }
            if (Modifier.isPublic(m2)) {
                return 1;
            }
            if (Modifier.isProtected(m1)) {
                return -1;
            }
            if (Modifier.isProtected(m2)) {
                return 1;
            }
            if (Modifier.isPrivate(m1)) {
                return -1;
            }
            if (Modifier.isPrivate(m2)) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && o instanceof MethodSorter;
        }

        public int hashCode() {
            return 42;
        }
    }
}

