/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.Map;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.internal.ClassPropertyHolder;
import org.hibernate.boot.model.internal.CollectionPropertyHolder;
import org.hibernate.boot.model.internal.ComponentPropertyHolder;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;

public final class PropertyHolderBuilder {
    private PropertyHolderBuilder() {
    }

    public static PropertyHolder buildPropertyHolder(XClass clazzToProcess, PersistentClass persistentClass, EntityBinder entityBinder, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        return new ClassPropertyHolder(persistentClass, clazzToProcess, entityBinder, context, inheritanceStatePerClass);
    }

    public static PropertyHolder buildPropertyHolder(Component component, String path, PropertyData inferredData, PropertyHolder parent, MetadataBuildingContext context) {
        return new ComponentPropertyHolder(component, path, inferredData, parent, context);
    }

    public static CollectionPropertyHolder buildPropertyHolder(Collection collection, String path, XClass clazzToProcess, XProperty property, PropertyHolder parentPropertyHolder, MetadataBuildingContext context) {
        return new CollectionPropertyHolder(collection, path, clazzToProcess, property, parentPropertyHolder, context);
    }

    public static PropertyHolder buildPropertyHolder(PersistentClass persistentClass, Map<String, Join> joins, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        return new ClassPropertyHolder(persistentClass, null, joins, context, inheritanceStatePerClass);
    }
}

