/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import jakarta.persistence.EnumType;
import java.io.Serializable;
import java.util.Locale;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.type.ConvertedBasicType;
import org.hibernate.type.descriptor.converter.internal.NamedEnumValueConverter;
import org.hibernate.type.descriptor.converter.internal.OrdinalEnumValueConverter;
import org.hibernate.type.descriptor.converter.spi.EnumValueConverter;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class EnumeratedValueResolution<E extends Enum<E>, R>
implements BasicValue.Resolution<E> {
    public static final String PREFIX = "enum::";
    private final EnumValueConverter<E, R> valueConverter;
    private final ConvertedBasicType<E> jdbcMapping;

    public EnumeratedValueResolution(JdbcType jdbcType, EnumValueConverter<E, R> valueConverter, MetadataBuildingContext context) {
        this.valueConverter = valueConverter;
        String externalizableName = this.createName(valueConverter);
        this.jdbcMapping = new ConvertedBasicTypeImpl<E>(externalizableName, jdbcType, valueConverter);
    }

    private String createName(EnumValueConverter<E, R> valueConverter) {
        return String.format(Locale.ROOT, "enum::%s::%s", ((Class)((AbstractClassJavaType)valueConverter.getDomainJavaType()).getJavaType()).getName(), EnumeratedValueResolution.enumStyle(valueConverter).name());
    }

    private static EnumType enumStyle(EnumValueConverter<?, ?> valueConverter) {
        if (valueConverter instanceof NamedEnumValueConverter) {
            return EnumType.STRING;
        }
        if (valueConverter instanceof OrdinalEnumValueConverter) {
            return EnumType.ORDINAL;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ConvertedBasicType<E> getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public ConvertedBasicType<E> getLegacyResolvedBasicType() {
        return this.jdbcMapping;
    }

    @Override
    public JavaType<E> getDomainJavaType() {
        return this.jdbcMapping.getJavaTypeDescriptor();
    }

    @Override
    public JavaType<?> getRelationalJavaType() {
        return this.jdbcMapping.getJdbcJavaType();
    }

    @Override
    public JdbcType getJdbcType() {
        return this.jdbcMapping.getJdbcType();
    }

    @Override
    public EnumValueConverter<E, R> getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public MutabilityPlan<E> getMutabilityPlan() {
        return ImmutableMutabilityPlan.instance();
    }

    public static <E extends Enum<E>> EnumeratedValueResolution<E, ?> fromName(String name, JdbcTypeIndicators jdbcTypeIndicators, MetadataBuildingContext context) {
        Serializable converter;
        JdbcType jdbcType;
        assert (name != null);
        assert (name.startsWith(PREFIX));
        String[] parts = StringHelper.split("::", name);
        assert (parts.length == 3);
        assert ("enum".equals(parts[0]));
        TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
        Class<E> enumClass = EnumeratedValueResolution.resolveEnumClass(parts[1], context.getBootstrapContext());
        EnumType style = EnumType.valueOf((String)parts[2]);
        EnumJavaType enumJavaType = (EnumJavaType)javaTypeRegistry.getDescriptor(enumClass);
        if (style == EnumType.ORDINAL) {
            jdbcType = jdbcTypeRegistry.getDescriptor(enumJavaType.hasManyValues() ? 5 : -6);
            JavaType jdbcJavaType = jdbcType.getJdbcRecommendedJavaTypeMapping(jdbcTypeIndicators.getColumnPrecision(), jdbcTypeIndicators.getColumnScale(), typeConfiguration);
            converter = new OrdinalEnumValueConverter(enumJavaType, jdbcType, jdbcJavaType);
        } else if (style == EnumType.STRING) {
            jdbcType = jdbcTypeRegistry.getDescriptor(jdbcTypeIndicators.getColumnLength() == 1L ? 1 : 12);
            JavaType<String> jdbcJavaType = jdbcType.getJdbcRecommendedJavaTypeMapping(jdbcTypeIndicators.getColumnPrecision(), jdbcTypeIndicators.getColumnScale(), typeConfiguration);
            converter = new NamedEnumValueConverter(enumJavaType, jdbcType, jdbcJavaType);
        } else {
            throw new IllegalArgumentException();
        }
        return new EnumeratedValueResolution(jdbcType, converter, context);
    }

    private static <E extends Enum<E>> Class<E> resolveEnumClass(String enumClassName, BootstrapContext bootstrapContext) {
        StandardServiceRegistry serviceRegistry = bootstrapContext.getServiceRegistry();
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        return classLoaderService.classForName(enumClassName);
    }
}

