/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import oracle.jdbc.OracleConnection;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleArrayJdbcType
extends ArrayJdbcType {
    private final String typeName;

    public OracleArrayJdbcType() {
        super(ObjectJdbcType.INSTANCE);
        this.typeName = null;
    }

    private OracleArrayJdbcType(String typeName, JdbcType elementJdbcType) {
        super(elementJdbcType);
        this.typeName = typeName;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        return null;
    }

    @Override
    public JdbcType resolveType(TypeConfiguration typeConfiguration, Dialect dialect, JdbcType elementType, ColumnTypeInformation columnTypeInformation) {
        String typeName = columnTypeInformation.getTypeName();
        if (typeName == null || typeName.isBlank()) {
            typeName = dialect.getArrayTypeName(typeConfiguration.getDdlTypeRegistry().getTypeName(elementType.getDdlTypeCode(), dialect));
        }
        if (typeName == null) {
            return typeConfiguration.getJdbcTypeRegistry().getDescriptor(2009);
        }
        return new OracleArrayJdbcType(typeName, elementType);
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaType<X> javaTypeDescriptor) {
        final BasicPluralJavaType containerJavaType = (BasicPluralJavaType)((Object)javaTypeDescriptor);
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                st.setNull(index, 2003, OracleArrayJdbcType.this.typeName);
            }

            @Override
            protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                st.setNull(name, 2003, OracleArrayJdbcType.this.typeName);
            }

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                java.sql.Array arr = this.getArray(value, containerJavaType, options);
                st.setArray(index, arr);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                java.sql.Array arr = this.getArray(value, containerJavaType, options);
                try {
                    st.setObject(name, (Object)arr, 2003);
                }
                catch (SQLException ex) {
                    throw new HibernateException("JDBC driver does not support named parameters for setArray. Use positional.", ex);
                }
            }

            private java.sql.Array getArray(X value, BasicPluralJavaType<X> containerJavaType2, WrapperOptions options) throws SQLException {
                Class<?> arrayClass = Array.newInstance(OracleArrayJdbcType.this.getElementJdbcType().getPreferredJavaTypeClass(options), 0).getClass();
                Object[] objects = (Object[])javaTypeDescriptor.unwrap(value, arrayClass, options);
                SharedSessionContractImplementor session = options.getSession();
                OracleConnection oracleConnection = session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection().unwrap(OracleConnection.class);
                try {
                    return oracleConnection.createOracleArray(OracleArrayJdbcType.this.typeName, (Object)objects);
                }
                catch (Exception e) {
                    throw new HibernateException("Couldn't create a java.sql.Array", e);
                }
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OracleArrayJdbcType that = (OracleArrayJdbcType)o;
        return Objects.equals(this.typeName, that.typeName);
    }

    @Override
    public int hashCode() {
        return this.typeName != null ? this.typeName.hashCode() : 0;
    }
}

