/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.dialect.SqlAstTranslatorWithUpsert;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.FrameExclusion;
import org.hibernate.query.sqm.FrameKind;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.expression.AggregateColumnWriteExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.UnionTableGroup;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.internal.OptionalTableUpdate;

public class OracleSqlAstTranslator<T extends JdbcOperation>
extends SqlAstTranslatorWithUpsert<T> {
    public OracleSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected boolean needsRecursiveKeywordInWithClause() {
        return false;
    }

    @Override
    protected boolean supportsWithClauseInSubquery() {
        return false;
    }

    @Override
    protected boolean supportsRecursiveSearchClause() {
        return true;
    }

    @Override
    protected boolean supportsRecursiveCycleClause() {
        return true;
    }

    @Override
    public void visitSqlSelection(SqlSelection sqlSelection) {
        if (this.getCurrentCteStatement() != null && this.getCurrentCteStatement().getMaterialization() == CteMaterialization.MATERIALIZED) {
            this.appendSql("/*+ materialize */ ");
        }
        super.visitSqlSelection(sqlSelection);
    }

    @Override
    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        AbstractSqlAstTranslator.LockStrategy strategy = super.determineLockingStrategy(querySpec, forUpdateClause, followOnLocking);
        boolean followOnLockingDisabled = Boolean.FALSE.equals(followOnLocking);
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && querySpec.hasSortSpecifications()) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with ORDER BY is not supported");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.isPartOfQueryGroup()) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with set operators is not supported");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.hasSetOperations(querySpec)) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with set operators is not supported");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON && this.useOffsetFetchClause(querySpec) && !this.isRowsOnlyFetchClauseType(querySpec)) {
            if (followOnLockingDisabled) {
                throw new IllegalQueryOperationException("Locking with FETCH is not supported");
            }
            strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
        }
        if (strategy != AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON) {
            boolean hasOffset;
            if (querySpec.isRoot() && this.hasLimit() && this.getLimit().getFirstRow() != null) {
                hasOffset = true;
                this.addAppliedParameterBinding(this.getOffsetParameter(), null);
            } else {
                boolean bl = hasOffset = querySpec.getOffsetClauseExpression() != null;
            }
            if (hasOffset) {
                if (followOnLockingDisabled) {
                    throw new IllegalQueryOperationException("Locking with OFFSET is not supported");
                }
                strategy = AbstractSqlAstTranslator.LockStrategy.FOLLOW_ON;
            }
        }
        return strategy;
    }

    private boolean hasSetOperations(QuerySpec querySpec) {
        return querySpec.getFromClause().queryTableGroups(group -> group instanceof UnionTableGroup ? group : null) != null;
    }

    private boolean isPartOfQueryGroup() {
        return this.getQueryPartStack().findCurrentFirst(OracleSqlAstTranslator::partIsQueryGroup) != null;
    }

    private static QueryPart partIsQueryGroup(QueryPart part) {
        return part instanceof QueryGroup ? part : null;
    }

    @Override
    protected boolean shouldEmulateLateralWithIntersect(QueryPart queryPart) {
        return !queryPart.hasOffsetOrFetchClause();
    }

    @Override
    protected boolean supportsNestedSubqueryCorrelation() {
        return false;
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        boolean hasLimit;
        if (this.getQueryPartForRowNumbering() == queryPart) {
            return false;
        }
        boolean bl = hasLimit = queryPart.isRoot() && this.hasLimit() || queryPart.getFetchClauseExpression() != null || queryPart.getOffsetClauseExpression() != null;
        if (!hasLimit) {
            return false;
        }
        if (this.supportsOffsetFetchClause()) {
            return !queryPart.hasSortSpecifications() && !this.hasOffset(queryPart) || queryPart instanceof QueryGroup && this.getClauseStack().isEmpty() && this.getStatement() instanceof InsertSelectStatement;
        }
        return true;
    }

    @Override
    protected FetchClauseType getFetchClauseTypeForRowNumbering(QueryPart queryPart) {
        boolean hasOffset;
        FetchClauseType fetchClauseType = super.getFetchClauseTypeForRowNumbering(queryPart);
        if (queryPart.isRoot() && this.hasLimit()) {
            hasOffset = this.getLimit().getFirstRow() != null;
        } else {
            boolean bl = hasOffset = queryPart.getOffsetClauseExpression() != null;
        }
        if (queryPart instanceof QuerySpec && !hasOffset && fetchClauseType == FetchClauseType.ROWS_ONLY) {
            return null;
        }
        return fetchClauseType;
    }

    @Override
    protected void emulateFetchOffsetWithWindowFunctions(QueryPart queryPart, Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, boolean emulateFetchClause) {
        if (queryPart instanceof QuerySpec && offsetExpression == null && fetchClauseType == FetchClauseType.ROWS_ONLY) {
            QuerySpec querySpec = (QuerySpec)queryPart;
            this.withRowNumbering(querySpec, true, () -> {
                this.appendSql("select * from ");
                this.emulateFetchOffsetWithWindowFunctionsVisitQueryPart(querySpec);
                this.appendSql(" where rownum<=");
                Stack<Clause> clauseStack = this.getClauseStack();
                clauseStack.push(Clause.WHERE);
                try {
                    fetchExpression.accept(this);
                    clauseStack.pop();
                    clauseStack.push(Clause.FOR_UPDATE);
                    this.visitForUpdateClause(querySpec);
                }
                finally {
                    clauseStack.pop();
                }
            });
        } else {
            super.emulateFetchOffsetWithWindowFunctions(queryPart, offsetExpression, fetchExpression, fetchClauseType, emulateFetchClause);
        }
    }

    @Override
    protected void visitOrderBy(List<SortSpecification> sortSpecifications) {
        QuerySpec querySpec;
        QueryPart queryPartForRowNumbering = this.getQueryPartForRowNumbering();
        if (queryPartForRowNumbering == null) {
            this.renderOrderBy(true, sortSpecifications);
        } else if (!(this.getFetchClauseTypeForRowNumbering(queryPartForRowNumbering) != null || (querySpec = (QuerySpec)queryPartForRowNumbering).getOffsetClauseExpression() != null || querySpec.isRoot() && this.getOffsetParameter() != null)) {
            this.renderOrderBy(true, sortSpecifications);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void visitValuesList(List<Values> valuesList) {
        if (valuesList.size() < 2) {
            super.visitValuesList(valuesList);
        } else {
            String separator = "";
            Stack<Clause> clauseStack = this.getClauseStack();
            try {
                clauseStack.push(Clause.VALUES);
                for (Values values : valuesList) {
                    this.appendSql(separator);
                    this.renderExpressionsAsSubquery(values.getExpressions());
                    separator = " union all ";
                }
            }
            finally {
                clauseStack.pop();
            }
        }
    }

    @Override
    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.emulateValuesTableReferenceColumnAliasing(tableReference);
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
    }

    @Override
    public void visitFunctionTableReference(FunctionTableReference tableReference) {
        this.append("table(");
        tableReference.getFunctionExpression().accept(this);
        this.append(')');
        this.renderTableReferenceIdentificationVariable(tableReference);
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    protected boolean supportsSimpleQueryGrouping() {
        return this.supportsOffsetFetchClause();
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.supportsOffsetFetchClause()) {
                if (this.getQueryPartStack().depth() > 1 && queryPart.hasSortSpecifications() && this.getQueryPartStack().peek(1) instanceof QueryGroup && (queryPart.isRoot() && !this.hasLimit() || !queryPart.hasOffsetOrFetchClause())) {
                    this.appendSql(" offset 0 rows");
                } else {
                    this.renderOffsetFetchClause(queryPart, true);
                }
            } else {
                this.assertRowsOnlyFetchClauseType(queryPart);
            }
        }
    }

    @Override
    protected void renderRowNumber(SelectClause selectClause, QueryPart queryPart) {
        if (!queryPart.hasSortSpecifications()) {
            this.appendSql("rownum");
        } else {
            super.renderRowNumber(selectClause, queryPart);
        }
    }

    @Override
    public void visitOver(Over<?> over) {
        Expression expression = over.getExpression();
        if (expression instanceof FunctionExpression && "row_number".equals(((FunctionExpression)expression).getFunctionName()) && over.getPartitions().isEmpty() && over.getOrderList().isEmpty() && over.getStartKind() == FrameKind.UNBOUNDED_PRECEDING && over.getEndKind() == FrameKind.CURRENT_ROW && over.getExclusion() == FrameExclusion.NO_OTHERS) {
            this.append("row_number() over(order by 1)");
            return;
        }
        super.visitOver(over);
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        JdbcMappingContainer lhsExpressionType = lhs.getExpressionType();
        if (lhsExpressionType == null || lhsExpressionType.getJdbcTypeCount() != 1) {
            this.renderComparisonEmulateDecode(lhs, operator, rhs);
            return;
        }
        switch (lhsExpressionType.getSingleJdbcMapping().getJdbcType().getDdlTypeCode()) {
            case 2009: {
                switch (operator) {
                    case EQUAL: 
                    case NOT_DISTINCT_FROM: {
                        this.appendSql("0=");
                        break;
                    }
                    case NOT_EQUAL: 
                    case DISTINCT_FROM: {
                        this.appendSql("1=");
                        break;
                    }
                    default: {
                        this.renderComparisonEmulateDecode(lhs, operator, rhs);
                        return;
                    }
                }
                this.appendSql("existsnode(xmldiff(");
                lhs.accept(this);
                this.appendSql(',');
                rhs.accept(this);
                this.appendSql("),'/*[local-name()=''xdiff'']/*')");
                break;
            }
            case 2004: 
            case 2005: 
            case 2011: {
                switch (operator) {
                    case EQUAL: {
                        this.appendSql("0=");
                        break;
                    }
                    case NOT_EQUAL: {
                        this.appendSql("-1=");
                        break;
                    }
                    default: {
                        this.renderComparisonEmulateDecode(lhs, operator, rhs);
                        return;
                    }
                }
                this.appendSql("dbms_lob.compare(");
                lhs.accept(this);
                this.appendSql(',');
                rhs.accept(this);
                this.appendSql(')');
                break;
            }
            default: {
                this.renderComparisonEmulateDecode(lhs, operator, rhs);
            }
        }
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
        } else {
            expression.accept(this);
        }
    }

    @Override
    protected boolean supportsDuplicateSelectItemsInQueryGroup() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return true;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInSubQuery() {
        return true;
    }

    @Override
    protected String getFromDual() {
        return " from dual";
    }

    @Override
    protected String getFromDualForSelectOnly() {
        return this.getFromDual();
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().supportsFetchClause(FetchClauseType.ROWS_ONLY);
    }

    @Override
    protected boolean renderNamedTableReference(NamedTableReference tableReference, LockMode lockMode) {
        this.appendSql(tableReference.getTableExpression());
        this.registerAffectedTable(tableReference);
        this.renderTableReferenceIdentificationVariable(tableReference);
        return false;
    }

    @Override
    protected void visitSetAssignment(Assignment assignment) {
        List<ColumnReference> columnReferences = assignment.getAssignable().getColumnReferences();
        if (columnReferences.size() == 1) {
            columnReferences.get(0).appendColumnForWrite(this);
            this.appendSql('=');
            Expression assignedValue = assignment.getAssignedValue();
            SqlTuple sqlTuple = SqlTupleContainer.getSqlTuple(assignedValue);
            if (sqlTuple != null) {
                assert (sqlTuple.getExpressions().size() == 1);
                sqlTuple.getExpressions().get(0).accept(this);
            } else {
                assignedValue.accept(this);
            }
        } else {
            int separator = 40;
            for (ColumnReference columnReference : columnReferences) {
                this.appendSql((char)separator);
                columnReference.appendColumnForWrite(this);
                separator = 44;
            }
            this.appendSql(")=");
            assignment.getAssignedValue().accept(this);
        }
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        columnReference.appendReadExpression(this);
    }

    @Override
    public void visitAggregateColumnWriteExpression(AggregateColumnWriteExpression aggregateColumnWriteExpression) {
        aggregateColumnWriteExpression.appendWriteExpression(this, this);
    }

    @Override
    protected void renderMergeTargetAlias() {
        this.appendSql(" t");
    }

    @Override
    protected void renderMergeSourceAlias() {
        this.appendSql(" s");
    }

    @Override
    protected void renderMergeSource(OptionalTableUpdate optionalTableUpdate) {
        int i;
        List<ColumnValueBinding> valueBindings = optionalTableUpdate.getValueBindings();
        List<ColumnValueBinding> keyBindings = optionalTableUpdate.getKeyBindings();
        this.appendSql("(select ");
        for (i = 0; i < keyBindings.size(); ++i) {
            ColumnValueBinding keyBinding = keyBindings.get(i);
            if (i > 0) {
                this.appendSql(", ");
            }
            this.renderCasted(keyBinding.getValueExpression());
            this.appendSql(" ");
            this.appendSql(keyBinding.getColumnReference().getColumnExpression());
        }
        for (i = 0; i < valueBindings.size(); ++i) {
            this.appendSql(", ");
            ColumnValueBinding valueBinding = valueBindings.get(i);
            this.renderCasted(valueBinding.getValueExpression());
            this.appendSql(" ");
            this.appendSql(valueBinding.getColumnReference().getColumnExpression());
        }
        this.appendSql(" from dual)");
        this.renderMergeSourceAlias();
    }
}

