/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.Type;

public class FetchProfileHelper {
    public static Map<String, FetchProfile> getFetchProfiles(MetadataImplementor bootMetamodel, MappingMetamodel mappingMetamodel) {
        HashMap<String, FetchProfile> fetchProfiles = new HashMap<String, FetchProfile>();
        for (org.hibernate.mapping.FetchProfile mappingProfile : bootMetamodel.getFetchProfiles()) {
            FetchProfile fetchProfile = FetchProfileHelper.createFetchProfile(mappingMetamodel, mappingProfile);
            fetchProfiles.put(fetchProfile.getName(), fetchProfile);
        }
        return fetchProfiles;
    }

    private static FetchProfile createFetchProfile(MappingMetamodel mappingMetamodel, org.hibernate.mapping.FetchProfile mappingProfile) {
        FetchProfile fetchProfile = new FetchProfile(mappingProfile.getName());
        for (FetchProfile.Fetch mappingFetch : mappingProfile.getFetches()) {
            EntityPersister owner = FetchProfileHelper.getEntityPersister(mappingMetamodel, fetchProfile, mappingFetch);
            Type associationType = owner.getPropertyType(mappingFetch.getAssociation());
            if (associationType == null || !associationType.isAssociationType()) {
                throw new HibernateException("Fetch profile [" + fetchProfile.getName() + "] specified an association that does not exist [" + mappingFetch.getAssociation() + "]");
            }
            Fetch.Style fetchStyle = Fetch.Style.parse(mappingFetch.getStyle());
            fetchProfile.addFetch(new Association(owner, mappingFetch.getAssociation()), fetchStyle);
            ((Loadable)owner).registerAffectingFetchProfile(fetchProfile.getName());
        }
        return fetchProfile;
    }

    private static EntityPersister getEntityPersister(MappingMetamodel mappingMetamodel, FetchProfile fetchProfile, FetchProfile.Fetch mappingFetch) {
        EntityPersister persister;
        String entityName = mappingMetamodel.getImportedName(mappingFetch.getEntity());
        if (entityName != null && (persister = mappingMetamodel.getEntityDescriptor(entityName)) != null) {
            return persister;
        }
        throw new HibernateException("Unable to resolve entity reference [" + mappingFetch.getEntity() + "] in fetch profile [" + fetchProfile.getName() + "]");
    }
}

