/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractEmbeddableRepresentationStrategy
implements EmbeddableRepresentationStrategy {
    private final JavaType<?> embeddableJavaType;
    private final int propertySpan;
    private final PropertyAccess[] propertyAccesses;
    private final boolean hasCustomAccessors;
    private final Map<String, Integer> attributeNameToPositionMap;

    public AbstractEmbeddableRepresentationStrategy(Component bootDescriptor, JavaType<?> embeddableJavaType, RuntimeModelCreationContext creationContext) {
        this.propertySpan = bootDescriptor.getPropertySpan();
        this.embeddableJavaType = embeddableJavaType;
        this.propertyAccesses = new PropertyAccess[this.propertySpan];
        this.attributeNameToPositionMap = new ConcurrentHashMap<String, Integer>(this.propertySpan);
        boolean foundCustomAccessor = false;
        int i = 0;
        for (Property property : bootDescriptor.getProperties()) {
            this.propertyAccesses[i] = this.buildPropertyAccess(property);
            this.attributeNameToPositionMap.put(property.getName(), i);
            if (!property.isBasicPropertyAccessor()) {
                foundCustomAccessor = true;
            }
            ++i;
        }
        this.hasCustomAccessors = foundCustomAccessor;
    }

    protected abstract PropertyAccess buildPropertyAccess(Property var1);

    public JavaType<?> getEmbeddableJavaType() {
        return this.embeddableJavaType;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.getEmbeddableJavaType();
    }

    public int getPropertySpan() {
        return this.propertySpan;
    }

    public PropertyAccess[] getPropertyAccesses() {
        return this.propertyAccesses;
    }

    public boolean hasCustomAccessors() {
        return this.hasCustomAccessors;
    }

    @Override
    public PropertyAccess resolvePropertyAccess(Property bootAttributeDescriptor) {
        return this.propertyAccesses[this.attributeNameToPositionMap.get(bootAttributeDescriptor.getName())];
    }
}

