/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.derived;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Incubating;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.TupleType;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.derived.AnonymousTupleSimpleSqmPathSource;
import org.hibernate.query.derived.AnonymousTupleSqmAssociationPathSource;
import org.hibernate.query.derived.AnonymousTupleSqmPathSource;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.ObjectArrayJavaType;

@Incubating
public class AnonymousTupleType<T>
implements TupleType<T>,
DomainType<T>,
ReturnableType<T>,
SqmPathSource<T> {
    private final ObjectArrayJavaType javaTypeDescriptor;
    private final SqmSelectableNode<?>[] components;
    private final Map<String, Integer> componentIndexMap;

    public AnonymousTupleType(SqmSubQuery<T> subQuery) {
        this(AnonymousTupleType.extractSqmExpressibles(subQuery));
    }

    public AnonymousTupleType(SqmSelectableNode<?>[] components) {
        this.components = components;
        this.javaTypeDescriptor = new ObjectArrayJavaType(AnonymousTupleType.getTypeDescriptors(components));
        LinkedHashMap<String, Integer> map = CollectionHelper.linkedMapOfSize(components.length);
        for (int i = 0; i < components.length; ++i) {
            SqmSelectableNode<?> component = components[i];
            String alias = component.getAlias();
            if (alias == null) {
                throw new IllegalArgumentException("Component at index " + i + " has no alias, but alias is required");
            }
            map.put(alias, i);
        }
        this.componentIndexMap = map;
    }

    private static SqmSelectableNode<?>[] extractSqmExpressibles(SqmSubQuery<?> subQuery) {
        SqmSelectClause selectClause = ((SqmQuerySpec)subQuery.getQuerySpec()).getSelectClause();
        if (selectClause == null || selectClause.getSelectionItems().isEmpty()) {
            throw new IllegalArgumentException("subquery has no selection items");
        }
        return (SqmSelectableNode[])selectClause.getSelectionItems().toArray(SqmSelectableNode[]::new);
    }

    private static JavaType<?>[] getTypeDescriptors(SqmSelectableNode<?>[] components) {
        JavaType[] typeDescriptors = new JavaType[components.length];
        for (int i = 0; i < components.length; ++i) {
            typeDescriptors[i] = components[i].getExpressible().getExpressibleJavaType();
        }
        return typeDescriptors;
    }

    public AnonymousTupleTableGroupProducer resolveTableGroupProducer(String aliasStem, List<SqlSelection> sqlSelections, FromClauseAccess fromClauseAccess) {
        return new AnonymousTupleTableGroupProducer(this, aliasStem, sqlSelections, fromClauseAccess);
    }

    public List<String> determineColumnNames() {
        int componentCount = this.componentCount();
        ArrayList<String> columnNames = new ArrayList<String>(componentCount);
        for (int i = 0; i < componentCount; ++i) {
            SqmSelectableNode<?> selectableNode = this.getSelectableNode(i);
            String componentName = this.getComponentName(i);
            if (selectableNode instanceof SqmPath) {
                AnonymousTupleType.addColumnNames(columnNames, ((SqmPath)selectableNode).getNodeType().getSqmPathType(), componentName);
                continue;
            }
            columnNames.add(componentName);
        }
        return columnNames;
    }

    private static void addColumnNames(List<String> columnNames, DomainType<?> domainType, String componentName) {
        if (domainType instanceof EntityDomainType) {
            EntityDomainType entityDomainType = (EntityDomainType)domainType;
            SingularPersistentAttribute idAttribute = entityDomainType.findIdAttribute();
            Object idPath = idAttribute == null ? componentName : componentName + "_" + idAttribute.getName();
            AnonymousTupleType.addColumnNames(columnNames, entityDomainType.getIdentifierDescriptor().getSqmPathType(), (String)idPath);
        } else if (domainType instanceof ManagedDomainType) {
            for (Attribute attribute : ((ManagedDomainType)domainType).getAttributes()) {
                if (!(attribute instanceof SingularPersistentAttribute)) {
                    throw new IllegalArgumentException("Only embeddables without collections are supported");
                }
                Type attributeType = ((SingularPersistentAttribute)attribute).getType();
                AnonymousTupleType.addColumnNames(columnNames, attributeType, componentName + "_" + attribute.getName());
            }
        } else {
            columnNames.add(componentName);
        }
    }

    @Override
    public int componentCount() {
        return this.components.length;
    }

    @Override
    public String getComponentName(int index) {
        return this.components[index].getAlias();
    }

    @Override
    public List<String> getComponentNames() {
        return new ArrayList<String>(this.componentIndexMap.keySet());
    }

    @Override
    public SqmExpressible<?> get(int index) {
        return this.components[index].getExpressible();
    }

    @Override
    public SqmExpressible<?> get(String componentName) {
        Integer index = this.componentIndexMap.get(componentName);
        return index == null ? null : this.components[index].getExpressible();
    }

    protected Integer getIndex(String componentName) {
        return this.componentIndexMap.get(componentName);
    }

    public SqmSelectableNode<?> getSelectableNode(int index) {
        return this.components[index];
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        Integer index = this.componentIndexMap.get(name);
        if (index == null) {
            return null;
        }
        SqmSelectableNode<?> component = this.components[index];
        if (component instanceof SqmPath) {
            SqmPath sqmPath = (SqmPath)component;
            if (sqmPath.getNodeType() instanceof SingularPersistentAttribute) {
                return new AnonymousTupleSqmAssociationPathSource(name, sqmPath, ((SingularPersistentAttribute)sqmPath.getNodeType()).getType());
            }
            if (sqmPath.getNodeType() instanceof PluralPersistentAttribute) {
                return new AnonymousTupleSqmAssociationPathSource(name, sqmPath, ((PluralPersistentAttribute)sqmPath.getNodeType()).getElementType());
            }
            if (sqmPath.getNodeType() instanceof EntityDomainType) {
                return new AnonymousTupleSqmAssociationPathSource(name, sqmPath, (SimpleDomainType)sqmPath.getNodeType());
            }
            return new AnonymousTupleSqmPathSource(name, sqmPath);
        }
        return new AnonymousTupleSimpleSqmPathSource(name, (DomainType)component.getExpressible(), Bindable.BindableType.SINGULAR_ATTRIBUTE);
    }

    @Override
    public JavaType<T> getExpressibleJavaType() {
        return this.javaTypeDescriptor;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.ENTITY_TYPE;
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }

    @Override
    public String getPathName() {
        return "tuple" + System.identityHashCode(this);
    }

    @Override
    public DomainType<?> getSqmPathType() {
        return this;
    }

    @Override
    public SqmPath<T> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        throw new UnsupportedMappingException("AnonymousTupleType cannot be used to create an SqmPath - that would be an SqmFrom which are created directly");
    }

    @Override
    public Class<T> getBindableJavaType() {
        return this.javaTypeDescriptor.getJavaType();
    }

    public Class<T> getJavaType() {
        return this.getBindableJavaType();
    }

    public String toString() {
        return "AnonymousTupleType" + Arrays.toString(this.components);
    }
}

