/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.derived;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.derived.AnonymousTupleBasicValuedModelPart;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteTable;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.type.BasicType;

@Incubating
public class CteTupleTableGroupProducer
extends AnonymousTupleTableGroupProducer {
    private final AnonymousTupleBasicValuedModelPart searchModelPart;
    private final AnonymousTupleBasicValuedModelPart cycleMarkModelPart;
    private final AnonymousTupleBasicValuedModelPart cyclePathModelPart;

    public CteTupleTableGroupProducer(SqmCteTable<?> sqmCteTable, String aliasStem, List<SqlSelection> sqlSelections, FromClauseAccess fromClauseAccess) {
        super(sqmCteTable, aliasStem, sqlSelections, fromClauseAccess);
        SqmCteStatement<?> cteStatement = sqmCteTable.getCteStatement();
        BasicType<String> stringType = cteStatement.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(String.class);
        this.searchModelPart = CteTupleTableGroupProducer.createModelPart(cteStatement.getSearchAttributeName(), stringType);
        this.cycleMarkModelPart = CteTupleTableGroupProducer.createModelPart(cteStatement.getCycleMarkAttributeName(), cteStatement.getCycleLiteral() == null ? null : (BasicType)cteStatement.getCycleLiteral().getNodeType());
        this.cyclePathModelPart = CteTupleTableGroupProducer.createModelPart(cteStatement.getCyclePathAttributeName(), stringType);
    }

    private static AnonymousTupleBasicValuedModelPart createModelPart(String attributeName, BasicType<?> basicType) {
        if (attributeName != null) {
            return new AnonymousTupleBasicValuedModelPart(attributeName, attributeName, basicType, basicType, -1);
        }
        return null;
    }

    public List<CteColumn> determineCteColumns() {
        ArrayList<CteColumn> columns = new ArrayList<CteColumn>(this.getModelParts().size());
        this.forEachSelectable((selectionIndex, selectableMapping) -> columns.add(new CteColumn(selectableMapping.getSelectionExpression(), selectableMapping.getJdbcMapping())));
        return columns;
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        ModelPart subPart = super.findSubPart(name, treatTargetType);
        if (subPart != null) {
            return subPart;
        }
        if (this.searchModelPart != null && name.equals(this.searchModelPart.getPartName())) {
            return this.searchModelPart;
        }
        if (this.cycleMarkModelPart != null && name.equals(this.cycleMarkModelPart.getPartName())) {
            return this.cycleMarkModelPart;
        }
        if (this.cyclePathModelPart != null && name.equals(this.cyclePathModelPart.getPartName())) {
            return this.cyclePathModelPart;
        }
        return null;
    }
}

