/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.from;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.PathException;
import org.hibernate.query.criteria.JpaEntityJoin;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmQualifiedJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedEntityJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedEntityJoin;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.spi.NavigablePath;

public class SqmEntityJoin<T>
extends AbstractSqmQualifiedJoin<T, T>
implements JpaEntityJoin<T> {
    private final SqmRoot<?> sqmRoot;

    public SqmEntityJoin(EntityDomainType<T> joinedEntityDescriptor, String alias, SqmJoinType joinType, SqmRoot<?> sqmRoot) {
        this(SqmCreationHelper.buildRootNavigablePath(joinedEntityDescriptor.getHibernateEntityName(), alias), joinedEntityDescriptor, alias, joinType, sqmRoot);
    }

    protected SqmEntityJoin(NavigablePath navigablePath, EntityDomainType<T> joinedEntityDescriptor, String alias, SqmJoinType joinType, SqmRoot<?> sqmRoot) {
        super(navigablePath, joinedEntityDescriptor, sqmRoot, alias, joinType, sqmRoot.nodeBuilder());
        this.sqmRoot = sqmRoot;
    }

    @Override
    public SqmEntityJoin<T> copy(SqmCopyContext context) {
        SqmEntityJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmEntityJoin<T> path = context.registerCopy(this, new SqmEntityJoin<T>(this.getNavigablePath(), this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), (SqmRoot<?>)this.getRoot().copy(context)));
        this.copyTo(path, context);
        return path;
    }

    public SqmRoot<?> getRoot() {
        return this.sqmRoot;
    }

    @Override
    public SqmRoot<?> findRoot() {
        return this.getRoot();
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        return null;
    }

    @Override
    public EntityDomainType<T> getModel() {
        return (EntityDomainType)super.getModel();
    }

    @Override
    public SqmPath<?> getLhs() {
        return null;
    }

    @Override
    public EntityDomainType<T> getReferencedPathSource() {
        return (EntityDomainType)super.getReferencedPathSource();
    }

    public String getEntityName() {
        return this.getReferencedPathSource().getHibernateEntityName();
    }

    @Override
    public SqmEntityJoin<T> on(JpaExpression<Boolean> restriction) {
        return (SqmEntityJoin)super.on(restriction);
    }

    @Override
    public SqmEntityJoin<T> on(Expression<Boolean> restriction) {
        return (SqmEntityJoin)super.on(restriction);
    }

    @Override
    public SqmEntityJoin<T> on(JpaPredicate ... restrictions) {
        return (SqmEntityJoin)super.on(restrictions);
    }

    @Override
    public SqmEntityJoin<T> on(Predicate ... restrictions) {
        return (SqmEntityJoin)super.on(restrictions);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitQualifiedEntityJoin(this);
    }

    @Override
    public <S extends T> SqmTreatedEntityJoin<T, S> treatAs(Class<S> treatJavaType) throws PathException {
        return this.treatAs((EntityDomainType)this.nodeBuilder().getDomainModel().entity(treatJavaType));
    }

    @Override
    public <S extends T> SqmTreatedEntityJoin<T, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        SqmTreatedEntityJoin treat = (SqmTreatedEntityJoin)this.findTreat(treatTarget, null);
        if (treat == null) {
            return this.addTreat(new SqmTreatedEntityJoin(this, treatTarget, null));
        }
        return treat;
    }

    @Override
    public <S extends T> SqmFrom<?, S> treatAs(Class<S> treatJavaType, String alias) {
        throw new UnsupportedOperationException("Entity join treats can not be aliased");
    }

    @Override
    public <S extends T> SqmFrom<?, S> treatAs(EntityDomainType<S> treatTarget, String alias) {
        throw new UnsupportedOperationException("Entity join treats can not be aliased");
    }

    public SqmCorrelatedEntityJoin<T> createCorrelation() {
        return new SqmCorrelatedEntityJoin(this);
    }

    public SqmEntityJoin<T> makeCopy(SqmCreationProcessingState creationProcessingState) {
        SqmPathRegistry pathRegistry = creationProcessingState.getPathRegistry();
        return new SqmEntityJoin<T>(this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), (SqmRoot)pathRegistry.findFromByPath(this.getRoot().getNavigablePath()));
    }
}

