/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast.builder;

import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.ast.ColumnValueBindingList;
import org.hibernate.sql.model.ast.RestrictedTableMutation;
import org.hibernate.sql.model.ast.builder.TableMutationBuilder;

public interface RestrictedTableMutationBuilder<O extends MutationOperation, M extends RestrictedTableMutation<O>>
extends TableMutationBuilder<M> {
    default public void addKeyRestrictions(SelectableMappings selectableMappings) {
        int jdbcTypeCount = selectableMappings.getJdbcTypeCount();
        for (int i = 0; i < jdbcTypeCount; ++i) {
            this.addKeyRestriction(selectableMappings.getSelectable(i));
        }
    }

    default public void addKeyRestrictionsLeniently(SelectableMappings selectableMappings) {
        int jdbcTypeCount = selectableMappings.getJdbcTypeCount();
        for (int i = 0; i < jdbcTypeCount; ++i) {
            this.addKeyRestrictionLeniently(selectableMappings.getSelectable(i));
        }
    }

    default public void addOptimisticLockRestrictions(SelectableMappings selectableMappings) {
        int jdbcTypeCount = selectableMappings.getJdbcTypeCount();
        for (int i = 0; i < jdbcTypeCount; ++i) {
            this.addOptimisticLockRestriction(selectableMappings.getSelectable(i));
        }
    }

    default public void addKeyRestriction(SelectableMapping selectableMapping) {
        if (selectableMapping.isNullable()) {
            return;
        }
        this.addKeyRestrictionLeniently(selectableMapping);
    }

    default public void addKeyRestrictionLeniently(SelectableMapping selectableMapping) {
        if (selectableMapping.isFormula()) {
            return;
        }
        this.addKeyRestriction(selectableMapping.getSelectionExpression(), selectableMapping.getWriteExpression(), selectableMapping.getJdbcMapping());
    }

    public void addKeyRestriction(String var1, String var2, JdbcMapping var3);

    public void addNullOptimisticLockRestriction(SelectableMapping var1);

    default public void addOptimisticLockRestriction(SelectableMapping selectableMapping) {
        this.addOptimisticLockRestriction(selectableMapping.getSelectionExpression(), selectableMapping.getWriteExpression(), selectableMapping.getJdbcMapping());
    }

    public void addOptimisticLockRestriction(String var1, String var2, JdbcMapping var3);

    public ColumnValueBindingList getKeyRestrictionBindings();

    public ColumnValueBindingList getOptimisticLockBindings();

    public void setWhere(String var1);

    public void addWhereFragment(String var1);
}

