/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import org.hibernate.LockMode;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.collection.CollectionResultGraphNode;
import org.hibernate.sql.results.graph.collection.internal.EagerCollectionAssembler;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.type.descriptor.java.JavaType;

public class CollectionDomainResult
implements DomainResult,
CollectionResultGraphNode,
FetchParent {
    private final NavigablePath loadingPath;
    private final PluralAttributeMapping loadingAttribute;
    private final String resultVariable;
    private final TableGroup tableGroup;
    private final DomainResult fkResult;
    private final CollectionInitializerProducer initializerProducer;

    public CollectionDomainResult(NavigablePath loadingPath, PluralAttributeMapping loadingAttribute, String resultVariable, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.loadingPath = loadingPath;
        this.loadingAttribute = loadingAttribute;
        this.resultVariable = resultVariable;
        this.tableGroup = tableGroup;
        this.fkResult = loadingAttribute.getKeyDescriptor().createKeyDomainResult(loadingPath, tableGroup, this, creationState);
        CollectionSemantics<?, ?> collectionSemantics = loadingAttribute.getCollectionDescriptor().getCollectionSemantics();
        this.initializerProducer = collectionSemantics.createInitializerProducer(loadingPath, loadingAttribute, this, true, null, creationState);
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public boolean containsAnyNonScalarResults() {
        return true;
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.loadingAttribute.getJavaType();
    }

    public DomainResultAssembler createResultAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        CollectionInitializer initializer = (CollectionInitializer)creationState.resolveInitializer(this.getNavigablePath(), this.getReferencedModePart(), () -> {
            DomainResultAssembler fkAssembler = this.fkResult.createResultAssembler(null, creationState);
            return this.initializerProducer.produceInitializer(this.loadingPath, this.loadingAttribute, null, LockMode.READ, fkAssembler, fkAssembler, creationState);
        });
        return new EagerCollectionAssembler(this.loadingAttribute, initializer);
    }

    @Override
    public FetchableContainer getReferencedMappingContainer() {
        return this.loadingAttribute;
    }

    @Override
    public FetchableContainer getReferencedMappingType() {
        return this.getReferencedMappingContainer();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.loadingPath;
    }

    @Override
    public ImmutableFetchList getFetches() {
        return ImmutableFetchList.EMPTY;
    }

    @Override
    public Fetch findFetch(Fetchable fetchable) {
        return null;
    }

    @Override
    public boolean hasJoinFetches() {
        return false;
    }

    @Override
    public boolean containsCollectionFetches() {
        return false;
    }
}

