/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.SharedSessionContract;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractArrayJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.LongJavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public class LongPrimitiveArrayJavaType
extends AbstractArrayJavaType<long[], Long> {
    public static final LongPrimitiveArrayJavaType INSTANCE = new LongPrimitiveArrayJavaType();

    private LongPrimitiveArrayJavaType() {
        this(LongJavaType.INSTANCE);
    }

    protected LongPrimitiveArrayJavaType(JavaType<Long> baseDescriptor) {
        super(long[].class, baseDescriptor, new ArrayMutabilityPlan());
    }

    @Override
    public String extractLoggableRepresentation(long[] value) {
        return value == null ? super.extractLoggableRepresentation(null) : Arrays.toString(value);
    }

    @Override
    public boolean areEqual(long[] one, long[] another) {
        return Arrays.equals(one, another);
    }

    @Override
    public int extractHashCode(long[] value) {
        return Arrays.hashCode(value);
    }

    @Override
    public String toString(long[] value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append(value[0]);
        for (int i = 1; i < value.length; ++i) {
            sb.append(value[i]);
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public long[] fromString(CharSequence charSequence) {
        int elementStart;
        if (charSequence == null) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        char lastChar = charSequence.charAt(charSequence.length() - 1);
        char firstChar = charSequence.charAt(0);
        if (firstChar != '{' || lastChar != '}') {
            throw new IllegalArgumentException("Cannot parse given string into array of strings. First and last character must be { and }");
        }
        int len = charSequence.length();
        for (int i = elementStart = 1; i < len; ++i) {
            char c = charSequence.charAt(i);
            if (c != ',') continue;
            list.add(Long.parseLong(charSequence, elementStart, i, 10));
            elementStart = i + 1;
        }
        long[] result = new long[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Long)list.get(i);
        }
        return result;
    }

    @Override
    public <X> X unwrap(long[] value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (X)value;
        }
        if (Object[].class.isAssignableFrom(type)) {
            Class<?> preferredJavaTypeClass = type.getComponentType();
            Object[] unwrapped = (Object[])Array.newInstance(preferredJavaTypeClass, value.length);
            for (int i = 0; i < value.length; ++i) {
                unwrapped[i] = this.getElementJavaType().unwrap(value[i], preferredJavaTypeClass, options);
            }
            return (X)unwrapped;
        }
        if (type == byte[].class) {
            return (X)SerializationHelper.serialize((Serializable)value);
        }
        if (type == BinaryStream.class) {
            return (X)new BinaryStreamImpl(SerializationHelper.serialize((Serializable)value));
        }
        if (type.isArray()) {
            Class<?> preferredJavaTypeClass = type.getComponentType();
            Object unwrapped = Array.newInstance(preferredJavaTypeClass, value.length);
            for (int i = 0; i < value.length; ++i) {
                Array.set(unwrapped, i, this.getElementJavaType().unwrap(value[i], preferredJavaTypeClass, options));
            }
            return (X)unwrapped;
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> long[] wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Array) {
            try {
                value = ((java.sql.Array)value).getArray();
            }
            catch (SQLException ex) {
                throw new HibernateException(ex);
            }
        }
        if (value instanceof long[]) {
            return (long[])value;
        }
        if (value instanceof byte[]) {
            return (long[])SerializationHelper.deserialize((byte[])value);
        }
        if (value instanceof BinaryStream) {
            return (long[])SerializationHelper.deserialize(((BinaryStream)value).getBytes());
        }
        if (value.getClass().isArray()) {
            long[] wrapped = new long[Array.getLength(value)];
            for (int i = 0; i < wrapped.length; ++i) {
                wrapped[i] = (Long)this.getElementJavaType().wrap(Array.get(value, i), options);
            }
            return wrapped;
        }
        throw this.unknownWrap(value.getClass());
    }

    private static class ArrayMutabilityPlan
    implements MutabilityPlan<long[]> {
        private ArrayMutabilityPlan() {
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public long[] deepCopy(long[] value) {
            return value == null ? null : (long[])value.clone();
        }

        @Override
        public Serializable disassemble(long[] value, SharedSessionContract session) {
            return this.deepCopy(value);
        }

        @Override
        public long[] assemble(Serializable cached, SharedSessionContract session) {
            return this.deepCopy((long[])cached);
        }
    }
}

