/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.execution.impl;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneParallelWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.lucene.work.impl.IndexManagementWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;

public class LuceneIndexWorkspace
implements IndexWorkspace {
    private final LuceneWorkFactory factory;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final DetachedBackendSessionContext sessionContext;

    public LuceneIndexWorkspace(LuceneWorkFactory factory, WorkExecutionIndexManagerContext indexManagerContext, DetachedBackendSessionContext sessionContext) {
        this.factory = factory;
        this.indexManagerContext = indexManagerContext;
        this.sessionContext = sessionContext;
    }

    public CompletableFuture<?> mergeSegments() {
        return this.doSubmit(this.indexManagerContext.allManagementOrchestrators(), this.factory.mergeSegments(), false);
    }

    public CompletableFuture<?> purge(Set<String> routingKeys) {
        return this.doSubmit(this.indexManagerContext.managementOrchestrators(routingKeys), this.factory.deleteAll(this.sessionContext.tenantIdentifier(), routingKeys), true);
    }

    public CompletableFuture<?> flush() {
        return this.doSubmit(this.indexManagerContext.allManagementOrchestrators(), this.factory.flush(), false);
    }

    public CompletableFuture<?> refresh() {
        return this.doSubmit(this.indexManagerContext.allManagementOrchestrators(), this.factory.refresh(), false);
    }

    private <T> CompletableFuture<?> doSubmit(List<LuceneParallelWorkOrchestrator> orchestrators, IndexManagementWork<T> work, boolean commit) {
        CompletableFuture[] writeFutures = new CompletableFuture[orchestrators.size()];
        CompletableFuture[] writeAndCommitFutures = new CompletableFuture[orchestrators.size()];
        for (int i = 0; i < writeFutures.length; ++i) {
            CompletableFuture writeFuture;
            LuceneParallelWorkOrchestrator orchestrator = orchestrators.get(i);
            writeFutures[i] = writeFuture = new CompletableFuture();
            writeAndCommitFutures[i] = commit ? writeFutures[i].thenRun(orchestrator::forceCommitInCurrentThread) : writeFuture;
            orchestrator.submit(writeFuture, work);
        }
        return CompletableFuture.allOf(writeAndCommitFutures);
    }
}

