/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import java.util.LinkedList;
import java.util.concurrent.Executor;

public class TaskQueue {
    static final Logger log = LoggerFactory.getLogger(TaskQueue.class);
    private final LinkedList<Task> tasks = new LinkedList();
    private Executor current;
    private final Runnable runner = this::run;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        while (true) {
            Task task;
            LinkedList<Task> linkedList = this.tasks;
            synchronized (linkedList) {
                task = this.tasks.poll();
                if (task == null) {
                    this.current = null;
                    return;
                }
                if (task.exec != this.current) {
                    this.tasks.addFirst(task);
                    task.exec.execute(this.runner);
                    this.current = task.exec;
                    return;
                }
            }
            try {
                task.runnable.run();
                continue;
            }
            catch (Throwable t) {
                log.error("Caught unexpected Throwable", t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable task, Executor executor) {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.add(new Task(task, executor));
            if (this.current == null) {
                this.current = executor;
                executor.execute(this.runner);
            }
        }
    }

    private static class Task {
        private final Runnable runnable;
        private final Executor exec;

        public Task(Runnable runnable, Executor exec) {
            this.runnable = runnable;
            this.exec = exec;
        }
    }
}

