/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Arguments;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptionsConverter;
import io.vertx.core.net.impl.KeyStoreHelper;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

@DataObject(generateConverter=true, publicConverter=false)
public class PemKeyCertOptions
implements KeyCertOptions {
    private KeyStoreHelper helper;
    private List<String> keyPaths;
    private List<Buffer> keyValues;
    private List<String> certPaths;
    private List<Buffer> certValues;

    public PemKeyCertOptions() {
        this.init();
    }

    private void init() {
        this.keyPaths = new ArrayList<String>();
        this.keyValues = new ArrayList<Buffer>();
        this.certPaths = new ArrayList<String>();
        this.certValues = new ArrayList<Buffer>();
    }

    public PemKeyCertOptions(PemKeyCertOptions other) {
        this.keyPaths = other.keyPaths != null ? new ArrayList<String>(other.keyPaths) : new ArrayList();
        this.keyValues = other.keyValues != null ? new ArrayList<Buffer>(other.keyValues) : new ArrayList();
        this.certPaths = other.certPaths != null ? new ArrayList<String>(other.certPaths) : new ArrayList();
        this.certValues = other.certValues != null ? new ArrayList<Buffer>(other.certValues) : new ArrayList();
    }

    public PemKeyCertOptions(JsonObject json) {
        this.init();
        PemKeyCertOptionsConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        PemKeyCertOptionsConverter.toJson(this, json);
        return json;
    }

    @GenIgnore
    public String getKeyPath() {
        return this.keyPaths.isEmpty() ? null : this.keyPaths.get(0);
    }

    public PemKeyCertOptions setKeyPath(String keyPath) {
        this.keyPaths.clear();
        if (keyPath != null) {
            this.keyPaths.add(keyPath);
        }
        return this;
    }

    public List<String> getKeyPaths() {
        return this.keyPaths;
    }

    public PemKeyCertOptions setKeyPaths(List<String> keyPaths) {
        this.keyPaths.clear();
        this.keyPaths.addAll(keyPaths);
        return this;
    }

    @GenIgnore
    public PemKeyCertOptions addKeyPath(String keyPath) {
        Arguments.require(keyPath != null, "Null keyPath");
        this.keyPaths.add(keyPath);
        return this;
    }

    @GenIgnore
    public Buffer getKeyValue() {
        return this.keyValues.isEmpty() ? null : this.keyValues.get(0);
    }

    public PemKeyCertOptions setKeyValue(Buffer keyValue) {
        this.keyValues.clear();
        if (keyValue != null) {
            this.keyValues.add(keyValue);
        }
        return this;
    }

    public List<Buffer> getKeyValues() {
        return this.keyValues;
    }

    public PemKeyCertOptions setKeyValues(List<Buffer> keyValues) {
        this.keyValues.clear();
        this.keyValues.addAll(keyValues);
        return this;
    }

    @GenIgnore
    public PemKeyCertOptions addKeyValue(Buffer keyValue) {
        Arguments.require(keyValue != null, "Null keyValue");
        this.keyValues.add(keyValue);
        return this;
    }

    @GenIgnore
    public String getCertPath() {
        return this.certPaths.isEmpty() ? null : this.certPaths.get(0);
    }

    public PemKeyCertOptions setCertPath(String certPath) {
        this.certPaths.clear();
        if (certPath != null) {
            this.certPaths.add(certPath);
        }
        return this;
    }

    public List<String> getCertPaths() {
        return this.certPaths;
    }

    public PemKeyCertOptions setCertPaths(List<String> certPaths) {
        this.certPaths.clear();
        this.certPaths.addAll(certPaths);
        return this;
    }

    @GenIgnore
    public PemKeyCertOptions addCertPath(String certPath) {
        Arguments.require(certPath != null, "Null certPath");
        this.certPaths.add(certPath);
        return this;
    }

    @GenIgnore
    public Buffer getCertValue() {
        return this.certValues.isEmpty() ? null : this.certValues.get(0);
    }

    public PemKeyCertOptions setCertValue(Buffer certValue) {
        this.certValues.clear();
        if (certValue != null) {
            this.certValues.add(certValue);
        }
        return this;
    }

    public List<Buffer> getCertValues() {
        return this.certValues;
    }

    public PemKeyCertOptions setCertValues(List<Buffer> certValues) {
        this.certValues.clear();
        this.certValues.addAll(certValues);
        return this;
    }

    @GenIgnore
    public PemKeyCertOptions addCertValue(Buffer certValue) {
        Arguments.require(certValue != null, "Null certValue");
        this.certValues.add(certValue);
        return this;
    }

    @Override
    public PemKeyCertOptions copy() {
        return new PemKeyCertOptions(this);
    }

    KeyStoreHelper getHelper(Vertx vertx) throws Exception {
        if (this.helper == null) {
            ArrayList<Buffer> keys = new ArrayList<Buffer>();
            for (String keyPath : this.keyPaths) {
                keys.add(vertx.fileSystem().readFileBlocking(((VertxInternal)vertx).resolveFile(keyPath).getAbsolutePath()));
            }
            keys.addAll(this.keyValues);
            ArrayList<Buffer> certs = new ArrayList<Buffer>();
            for (String certPath : this.certPaths) {
                certs.add(vertx.fileSystem().readFileBlocking(((VertxInternal)vertx).resolveFile(certPath).getAbsolutePath()));
            }
            certs.addAll(this.certValues);
            this.helper = new KeyStoreHelper(KeyStoreHelper.loadKeyCert(keys, certs), "dummy", null);
        }
        return this.helper;
    }

    public KeyStore loadKeyStore(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper.store() : null;
    }

    @Override
    public KeyManagerFactory getKeyManagerFactory(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper.getKeyMgrFactory() : null;
    }

    @Override
    public Function<String, X509KeyManager> keyManagerMapper(Vertx vertx) throws Exception {
        KeyStoreHelper helper = this.getHelper(vertx);
        return helper != null ? helper::getKeyMgr : null;
    }
}

