/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.log4j;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logmanager.Level;

class LevelTranslator {
    private static final org.apache.logging.log4j.Level DEFAULT_LOG4J_LEVEL = org.apache.logging.log4j.Level.DEBUG;
    private static final Level DEFAULT_LEVEL = Level.DEBUG;
    private final Map<Integer, org.apache.logging.log4j.Level> julToLog4j = new HashMap<Integer, org.apache.logging.log4j.Level>();
    private final Map<Integer, java.util.logging.Level> log4jToJul = new HashMap<Integer, java.util.logging.Level>();

    private LevelTranslator() {
        this.julToLog4j.put(java.util.logging.Level.FINEST.intValue(), org.apache.logging.log4j.Level.TRACE);
        this.julToLog4j.put(java.util.logging.Level.CONFIG.intValue(), org.apache.logging.log4j.Level.DEBUG);
        this.julToLog4j.put(Level.ALL.intValue(), org.apache.logging.log4j.Level.ALL);
        this.julToLog4j.put(Level.TRACE.intValue(), org.apache.logging.log4j.Level.TRACE);
        this.julToLog4j.put(Level.DEBUG.intValue(), org.apache.logging.log4j.Level.DEBUG);
        this.julToLog4j.put(Level.INFO.intValue(), org.apache.logging.log4j.Level.INFO);
        this.julToLog4j.put(Level.WARN.intValue(), org.apache.logging.log4j.Level.WARN);
        this.julToLog4j.put(Level.ERROR.intValue(), org.apache.logging.log4j.Level.ERROR);
        this.julToLog4j.put(Level.FATAL.intValue(), org.apache.logging.log4j.Level.FATAL);
        this.julToLog4j.put(Level.OFF.intValue(), org.apache.logging.log4j.Level.OFF);
        this.log4jToJul.put(org.apache.logging.log4j.Level.ALL.intLevel(), Level.ALL);
        this.log4jToJul.put(org.apache.logging.log4j.Level.TRACE.intLevel(), (java.util.logging.Level)Level.TRACE);
        this.log4jToJul.put(org.apache.logging.log4j.Level.DEBUG.intLevel(), (java.util.logging.Level)Level.DEBUG);
        this.log4jToJul.put(org.apache.logging.log4j.Level.INFO.intLevel(), (java.util.logging.Level)Level.INFO);
        this.log4jToJul.put(org.apache.logging.log4j.Level.WARN.intLevel(), (java.util.logging.Level)Level.WARN);
        this.log4jToJul.put(org.apache.logging.log4j.Level.ERROR.intLevel(), (java.util.logging.Level)Level.ERROR);
        this.log4jToJul.put(org.apache.logging.log4j.Level.FATAL.intLevel(), (java.util.logging.Level)Level.FATAL);
        this.log4jToJul.put(org.apache.logging.log4j.Level.OFF.intLevel(), Level.OFF);
    }

    static LevelTranslator getInstance() {
        return Holder.INSTANCE;
    }

    java.util.logging.Level translateLevel(org.apache.logging.log4j.Level level) {
        java.util.logging.Level result = level == null ? null : this.log4jToJul.get(level.intLevel());
        return result == null ? DEFAULT_LEVEL : result;
    }

    org.apache.logging.log4j.Level translateLevel(java.util.logging.Level level) {
        return level == null ? DEFAULT_LOG4J_LEVEL : this.translateLevel(level.intValue());
    }

    org.apache.logging.log4j.Level translateLevel(int level) {
        org.apache.logging.log4j.Level result = this.julToLog4j.get(level);
        return result == null ? DEFAULT_LOG4J_LEVEL : result;
    }

    private static class Holder {
        static final LevelTranslator INSTANCE = new LevelTranslator();

        private Holder() {
        }
    }
}

