/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.extensions.mysql;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getClassLoader(final Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return c.getClassLoader();
            }
        });
    }

    static ClassLoader getThreadContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setAccessible(final Method m) {
        if (m == null) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                m.setAccessible(true);
                return null;
            }
        });
    }

    static Method getMethod(final Class<?> c, final String name, final Class<?> ... params) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return c.getMethod(name, params);
        }
        Method result = AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return c.getMethod(name, params);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
        if (result != null) {
            return result;
        }
        throw new NoSuchMethodException();
    }
}

