/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorBinder;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoPropertyAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoValueAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathOriginalTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class PojoAssociationPathInverter {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider;
    private final ContainerExtractorBinder extractorBinder;

    PojoAssociationPathInverter(PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider, ContainerExtractorBinder extractorBinder) {
        this.typeAdditionalMetadataProvider = typeAdditionalMetadataProvider;
        this.extractorBinder = extractorBinder;
    }

    public Optional<PojoModelPathValueNode> invertPath(PojoTypeModel<?> inverseSideEntityType, BoundPojoModelPathValueNode<?, ?, ?> pathToInvert) {
        PojoRawTypeModel<?> originalSideEntityType = pathToInvert.getRootType().rawType();
        Optional<PojoModelPathValueNode> inverseSidePathOptional = this.findInverseSidePathFromOriginalSide(pathToInvert);
        if (!inverseSidePathOptional.isPresent()) {
            List<PojoModelPathValueNode> associationPathsToMatch = this.computeAssociationPathsToMatch(pathToInvert);
            inverseSidePathOptional = this.findInverseSidePathFromInverseSide(inverseSideEntityType, originalSideEntityType, associationPathsToMatch);
        }
        return inverseSidePathOptional;
    }

    private List<PojoModelPathValueNode> computeAssociationPathsToMatch(BoundPojoModelPathValueNode<?, ?, ?> boundPathToInvert) {
        LinkedList<PojoModelPathValueNode> associationPathsToMatch = new LinkedList<PojoModelPathValueNode>();
        this.collectAssociationPathsToMatch(associationPathsToMatch, boundPathToInvert);
        return associationPathsToMatch;
    }

    private void collectAssociationPathsToMatch(List<PojoModelPathValueNode> associationPathsToMatch, BoundPojoModelPathValueNode<?, ?, ?> boundPathToInvert) {
        BoundPojoModelPath parentPath = boundPathToInvert.getParent();
        BoundPojoModelPath parentValuePath = ((BoundPojoModelPathTypeNode)((BoundPojoModelPathPropertyNode)parentPath).getParent()).getParent();
        String propertyName = ((BoundPojoModelPathPropertyNode)parentPath).getPropertyModel().name();
        ContainerExtractorPath extractorPath = boundPathToInvert.getExtractorPath();
        boolean isDefaultExtractorPath = this.isDefaultExtractorPath(((BoundPojoModelPathPropertyNode)parentPath).getPropertyModel(), boundPathToInvert.getBoundExtractorPath());
        if (parentValuePath != null) {
            this.collectAssociationPathsToMatch(associationPathsToMatch, (BoundPojoModelPathValueNode<?, ?, ?>)parentValuePath);
            ListIterator<PojoModelPathValueNode> iterator = associationPathsToMatch.listIterator();
            while (iterator.hasNext()) {
                PojoModelPathValueNode baseValuePath = iterator.next();
                PojoModelPathPropertyNode basePropertyPath = baseValuePath.property(propertyName);
                iterator.set(basePropertyPath.value(extractorPath));
                if (!isDefaultExtractorPath) continue;
                iterator.add(basePropertyPath.value(ContainerExtractorPath.defaultExtractors()));
            }
        } else {
            associationPathsToMatch.add(PojoModelPath.ofValue(propertyName, extractorPath));
            if (isDefaultExtractorPath) {
                associationPathsToMatch.add(PojoModelPath.ofValue(propertyName, ContainerExtractorPath.defaultExtractors()));
            }
        }
    }

    private boolean isDefaultExtractorPath(PojoPropertyModel<?> propertyModel, BoundContainerExtractorPath<?, ?> originalSideBoundExtractorPath) {
        return this.extractorBinder.isDefaultExtractorPath(propertyModel.typeModel(), originalSideBoundExtractorPath.getExtractorPath());
    }

    private Optional<PojoModelPathValueNode> findInverseSidePathFromOriginalSide(BoundPojoModelPathValueNode<?, ?, ?> pathToInvert) {
        BoundPojoModelPath lastPropertyNode = pathToInvert.getParent();
        BoundPojoModelPath lastTypeNode = ((BoundPojoModelPathPropertyNode)lastPropertyNode).getParent();
        PojoPropertyModel lastPropertyModel = ((BoundPojoModelPathPropertyNode)lastPropertyNode).getPropertyModel();
        PojoTypeModel lastTypeModel = ((BoundPojoModelPathTypeNode)lastTypeNode).getTypeModel();
        PojoTypeAdditionalMetadata typeAdditionalMetadata = this.typeAdditionalMetadataProvider.get(lastTypeModel.rawType());
        PojoPropertyAdditionalMetadata propertyAdditionalMetadata = typeAdditionalMetadata.getPropertyAdditionalMetadata(((BoundPojoModelPathPropertyNode)lastPropertyNode).getPropertyModel().name());
        Optional<PojoModelPathValueNode> result = propertyAdditionalMetadata.getValueAdditionalMetadata(pathToInvert.getExtractorPath()).getInverseSidePath();
        if (result.isPresent()) {
            return result;
        }
        if (this.isDefaultExtractorPath(lastPropertyModel, pathToInvert.getBoundExtractorPath())) {
            result = propertyAdditionalMetadata.getValueAdditionalMetadata(ContainerExtractorPath.defaultExtractors()).getInverseSidePath();
        }
        return result;
    }

    private Optional<PojoModelPathValueNode> findInverseSidePathFromInverseSide(PojoTypeModel<?> inverseSideTypeModel, PojoRawTypeModel<?> originalSideEntityType, List<PojoModelPathValueNode> associationPathsToMatch) {
        BoundPojoModelPathOriginalTypeNode<?> inverseSidePathTypeNode = BoundPojoModelPath.root(inverseSideTypeModel);
        HashSet encounteredAssociationHoldingTypes = new HashSet();
        return this.findInverseSidePathFromInverseSideRecursive(inverseSidePathTypeNode, originalSideEntityType, associationPathsToMatch, encounteredAssociationHoldingTypes);
    }

    private Optional<PojoModelPathValueNode> findInverseSidePathFromInverseSideRecursive(BoundPojoModelPathTypeNode<?> inverseSidePathTypeNode, PojoRawTypeModel<?> originalSideEntityType, List<PojoModelPathValueNode> associationPathsToMatch, Set<PojoRawTypeModel<?>> encounteredAssociationHoldingTypes) {
        PojoTypeModel<?> inverseSideTypeModel = inverseSidePathTypeNode.getTypeModel();
        PojoTypeAdditionalMetadata inverseSideTypeAdditionalMetadata = this.typeAdditionalMetadataProvider.get(inverseSideTypeModel.rawType());
        for (String inverseSidePropertyName : inverseSideTypeAdditionalMetadata.getNamesOfPropertiesWithAdditionalMetadata()) {
            BoundPojoModelPathPropertyNode<?, ?> inverseSidePathPropertyNode = inverseSidePathTypeNode.property(inverseSidePropertyName);
            PojoPropertyAdditionalMetadata inverseSidePropertyAdditionalMetadata = inverseSideTypeAdditionalMetadata.getPropertyAdditionalMetadata(inverseSidePropertyName);
            for (Map.Entry<ContainerExtractorPath, PojoValueAdditionalMetadata> valueEntry : inverseSidePropertyAdditionalMetadata.getValuesAdditionalMetadata().entrySet()) {
                PojoValueAdditionalMetadata inverseSideValueAdditionalMetadata;
                ContainerExtractorPath inverseSideExtractorPath = valueEntry.getKey();
                BoundPojoModelPathValueNode<?, ?, ?> inverseSidePathValueNode = this.bindExtractors(inverseSidePathPropertyNode, inverseSideExtractorPath);
                Optional<PojoModelPathValueNode> inverseSidePathOptional = this.findInverseSidePathFromInverseSideValueRecursive(originalSideEntityType, associationPathsToMatch, inverseSidePathValueNode, inverseSideValueAdditionalMetadata = valueEntry.getValue(), encounteredAssociationHoldingTypes);
                if (!inverseSidePathOptional.isPresent()) continue;
                return inverseSidePathOptional;
            }
        }
        return Optional.empty();
    }

    private Optional<PojoModelPathValueNode> findInverseSidePathFromInverseSideValueRecursive(PojoRawTypeModel<?> originalSideEntityType, List<PojoModelPathValueNode> associationPathsToMatch, BoundPojoModelPathValueNode<?, ?, ?> inverseSidePathValueNode, PojoValueAdditionalMetadata inverseSideValueAdditionalMetadata, Set<PojoRawTypeModel<?>> encounteredAssociationHoldingTypes) {
        Optional<PojoModelPathValueNode> candidatePathOptional = inverseSideValueAdditionalMetadata.getInverseSidePath();
        PojoRawTypeModel<?> rawExtractedTypeModel = inverseSidePathValueNode.type().getTypeModel().rawType();
        if (candidatePathOptional.isPresent() && associationPathsToMatch.contains(candidatePathOptional.get())) {
            PojoModelPathValueNode inverseAssociationPath = inverseSidePathValueNode.toUnboundPath();
            if (originalSideEntityType.isSubTypeOf(rawExtractedTypeModel)) {
                return Optional.of(inverseAssociationPath);
            }
        }
        if (inverseSideValueAdditionalMetadata.isAssociationEmbedded()) {
            if (encounteredAssociationHoldingTypes.contains(rawExtractedTypeModel)) {
                throw log.infiniteRecursionForAssociationEmbeddeds(inverseSidePathValueNode.getRootType().rawType(), inverseSidePathValueNode.toUnboundPath());
            }
            encounteredAssociationHoldingTypes.add(rawExtractedTypeModel);
            candidatePathOptional = this.findInverseSidePathFromInverseSideRecursive(inverseSidePathValueNode.type(), originalSideEntityType, associationPathsToMatch, encounteredAssociationHoldingTypes);
            encounteredAssociationHoldingTypes.remove(rawExtractedTypeModel);
            if (candidatePathOptional.isPresent()) {
                return candidatePathOptional;
            }
        }
        return Optional.empty();
    }

    private <P> BoundPojoModelPathValueNode<?, P, ?> bindExtractors(BoundPojoModelPathPropertyNode<?, P> inverseSidePathPropertyNode, ContainerExtractorPath extractorPath) {
        BoundContainerExtractorPath<P, ?> resolvedExtractorPath = this.extractorBinder.bindPath(inverseSidePathPropertyNode.getPropertyModel().typeModel(), extractorPath);
        return inverseSidePathPropertyNode.value(resolvedExtractorPath);
    }
}

