/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.loading.impl;

import java.util.Collection;
import java.util.Optional;
import org.hibernate.search.engine.common.timing.Deadline;
import org.hibernate.search.mapper.pojo.loading.impl.PojoMultiLoaderLoadingPlan;
import org.hibernate.search.mapper.pojo.loading.impl.PojoSingleLoaderLoadingPlan;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingStrategy;

public interface PojoLoadingPlan<T> {
    public static <T> PojoLoadingPlan<T> create(PojoSelectionLoadingContext context, Collection<? extends PojoLoadingTypeContext<? extends T>> targetTypes) {
        PojoSelectionLoadingStrategy<T> strategy = null;
        for (PojoLoadingTypeContext<T> pojoLoadingTypeContext : targetTypes) {
            Optional<PojoSelectionLoadingStrategy<T>> thisTypeStrategyOptional = context.loadingStrategyOptional(pojoLoadingTypeContext);
            if (!thisTypeStrategyOptional.isPresent()) {
                return new PojoMultiLoaderLoadingPlan(context);
            }
            PojoSelectionLoadingStrategy<T> thisTypeStrategy = thisTypeStrategyOptional.get();
            if (strategy == null) {
                strategy = thisTypeStrategy;
                continue;
            }
            if (strategy.equals(thisTypeStrategy)) continue;
            return new PojoMultiLoaderLoadingPlan(context);
        }
        return new PojoSingleLoaderLoadingPlan(context, strategy);
    }

    public <T2 extends T> int planLoading(PojoLoadingTypeContext<T2> var1, Object var2);

    public void loadBlocking(Deadline var1);

    public <T2 extends T> T2 retrieve(PojoLoadingTypeContext<T2> var1, int var2);

    public void clear();
}

