/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierSink;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingFailureHandledRunnable;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeGroup;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingNotifier;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoProducerConsumerQueue;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingIdentifierLoadingContext;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingLoadingStrategy;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoMassIndexingEntityIdentifierLoadingRunnable<E, I>
extends PojoMassIndexingFailureHandledRunnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoMassIndexingIndexedTypeGroup<E> typeGroup;
    private final PojoMassIndexingLoadingStrategy<E, I> loadingStrategy;
    private final PojoProducerConsumerQueue<List<I>> identifierQueue;

    public PojoMassIndexingEntityIdentifierLoadingRunnable(PojoMassIndexingNotifier notifier, PojoMassIndexingIndexedTypeGroup<E> typeGroup, PojoMassIndexingLoadingStrategy<E, I> loadingStrategy, PojoProducerConsumerQueue<List<I>> identifierQueue) {
        super(notifier);
        this.loadingStrategy = loadingStrategy;
        this.typeGroup = typeGroup;
        this.identifierQueue = identifierQueue;
    }

    @Override
    protected void runWithFailureHandler() throws InterruptedException {
        log.trace("started");
        LoadingContext context = new LoadingContext();
        try (PojoMassIdentifierLoader loader = this.loadingStrategy.createIdentifierLoader(context);){
            long totalCount = loader.totalCount();
            this.getNotifier().reportAddedTotalCount(totalCount);
            do {
                loader.loadNext();
            } while (!context.done);
            this.identifierQueue.producerStopping();
        }
        log.trace("finished");
    }

    @Override
    protected void cleanUpOnFailure() {
    }

    @Override
    protected void cleanUpOnInterruption() {
    }

    @Override
    protected String operationName() {
        return log.massIndexerFetchingIds(this.typeGroup.notifiedGroupName());
    }

    private class LoadingContext
    implements PojoMassIndexingIdentifierLoadingContext<E, I> {
        private boolean done = false;

        private LoadingContext() {
        }

        @Override
        public Set<PojoRawTypeIdentifier<? extends E>> includedTypes() {
            return PojoMassIndexingEntityIdentifierLoadingRunnable.this.typeGroup.includedTypesIdentifiers();
        }

        @Override
        public PojoMassIdentifierSink<I> createSink() {
            return new PojoMassIdentifierSink<I>(){

                @Override
                public void accept(List<? extends I> batch) throws InterruptedException {
                    log.tracef("produced a list of ids %s", batch);
                    ArrayList copy = new ArrayList(batch);
                    PojoMassIndexingEntityIdentifierLoadingRunnable.this.identifierQueue.put(copy);
                }

                @Override
                public void complete() {
                    LoadingContext.this.done = true;
                }
            };
        }
    }
}

