/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.loading.impl;

import java.util.Map;
import org.hibernate.search.engine.backend.common.spi.DocumentReferenceConverter;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeSessionContext;
import org.hibernate.search.mapper.pojo.loading.impl.PojoLoadingPlan;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContext;
import org.hibernate.search.mapper.pojo.search.loading.impl.PojoProjectionHitMapper;
import org.hibernate.search.mapper.pojo.search.loading.impl.PojoSearchLoadingIndexedTypeContext;

public class PojoSearchLoadingContext<R, E>
implements SearchLoadingContext<R, E> {
    private final Map<String, PojoSearchLoadingIndexedTypeContext<? extends E>> targetTypesByEntityName;
    private final DocumentReferenceConverter<R> documentReferenceConverter;
    private final BridgeSessionContext sessionContext;
    private final PojoSelectionLoadingContext delegate;

    public PojoSearchLoadingContext(Map<String, PojoSearchLoadingIndexedTypeContext<? extends E>> targetTypesByEntityName, DocumentReferenceConverter<R> documentReferenceConverter, BridgeSessionContext sessionContext, PojoSelectionLoadingContext delegate) {
        this.targetTypesByEntityName = targetTypesByEntityName;
        this.documentReferenceConverter = documentReferenceConverter;
        this.sessionContext = sessionContext;
        this.delegate = delegate;
    }

    public PojoSelectionLoadingContext unwrap() {
        return this.delegate;
    }

    public ProjectionHitMapper<R, E> createProjectionHitMapper() {
        PojoLoadingPlan<? extends E> loadingPlan = PojoLoadingPlan.create(this.delegate, this.targetTypesByEntityName.values());
        return new PojoProjectionHitMapper<R, E>(this.targetTypesByEntityName, this.documentReferenceConverter, this.sessionContext, loadingPlan);
    }
}

