/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.PlatformDependent;

public abstract class AbstractByteBufPool<T> {
    public static final int DEFAULT_POOL_CAPACITY = 32;
    private final T[] entries;
    private final int mask;
    private final int shift;

    public AbstractByteBufPool() {
        this(32);
    }

    public AbstractByteBufPool(int capacity) {
        this.entries = new Object[MathUtil.findNextPositivePowerOfTwo((int)capacity)];
        this.mask = this.entries.length - 1;
        this.shift = 31 - Integer.numberOfLeadingZeros(this.entries.length);
    }

    private static int hashCode(ByteBuf bytes, int offset, int length) {
        if (PlatformDependent.isUnaligned() && PlatformDependent.hasUnsafe()) {
            if (bytes.hasArray()) {
                return AbstractByteBufPool.onHeapHashCode(bytes.array(), bytes.arrayOffset() + offset, length);
            }
            if (bytes.hasMemoryAddress()) {
                return AbstractByteBufPool.offHeapHashCode(bytes.memoryAddress(), offset, length);
            }
        }
        return AbstractByteBufPool.byteBufHashCode(bytes, offset, length);
    }

    private static int onHeapHashCode(byte[] bytes, int offset, int length) {
        int i;
        int intCount = length >>> 1;
        int byteCount = length & 1;
        int hashCode = 1;
        int arrayIndex = offset;
        for (i = 0; i < intCount; ++i) {
            hashCode = 31 * hashCode + PlatformDependent.getShort((byte[])bytes, (int)arrayIndex);
            arrayIndex += 2;
        }
        for (i = 0; i < byteCount; ++i) {
            hashCode = 31 * hashCode + PlatformDependent.getByte((byte[])bytes, (int)arrayIndex++);
        }
        return hashCode;
    }

    private static int offHeapHashCode(long address, int offset, int length) {
        int i;
        int intCount = length >>> 1;
        int byteCount = length & 1;
        int hashCode = 1;
        int arrayIndex = offset;
        for (i = 0; i < intCount; ++i) {
            hashCode = 31 * hashCode + PlatformDependent.getShort((long)(address + (long)arrayIndex));
            arrayIndex += 2;
        }
        for (i = 0; i < byteCount; ++i) {
            hashCode = 31 * hashCode + PlatformDependent.getByte((long)(address + (long)arrayIndex++));
        }
        return hashCode;
    }

    private static int byteBufHashCode(ByteBuf byteBuf, int offset, int length) {
        int i;
        int intCount = length >>> 1;
        int byteCount = length & 1;
        int hashCode = 1;
        int arrayIndex = offset;
        for (i = 0; i < intCount; ++i) {
            short shortLE = byteBuf.getShortLE(arrayIndex);
            short nativeShort = PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(shortLE) : shortLE;
            hashCode = 31 * hashCode + nativeShort;
            arrayIndex += 2;
        }
        for (i = 0; i < byteCount; ++i) {
            hashCode = 31 * hashCode + byteBuf.getByte(arrayIndex++);
        }
        return hashCode;
    }

    protected abstract boolean canPool(ByteBuf var1, int var2);

    protected abstract T create(ByteBuf var1, int var2);

    protected abstract boolean isEqual(T var1, ByteBuf var2, int var3, int var4);

    public final T getOrCreate(ByteBuf byteBuf) {
        int length = byteBuf.readInt();
        if (!this.canPool(byteBuf, length)) {
            return this.create(byteBuf, length);
        }
        if (!byteBuf.isReadable(length)) {
            throw new IndexOutOfBoundsException();
        }
        int bytesOffset = byteBuf.readerIndex();
        int hashCode = AbstractByteBufPool.hashCode(byteBuf, bytesOffset, length);
        int firstIndex = hashCode & this.mask;
        T firstEntry = this.entries[firstIndex];
        if (this.isEqual(firstEntry, byteBuf, bytesOffset, length)) {
            byteBuf.skipBytes(length);
            return firstEntry;
        }
        int secondIndex = hashCode >> this.shift & this.mask;
        T secondEntry = this.entries[secondIndex];
        if (this.isEqual(secondEntry, byteBuf, bytesOffset, length)) {
            byteBuf.skipBytes(length);
            return secondEntry;
        }
        T internedEntry = this.create(byteBuf, length);
        int entryIndex = firstEntry == null ? firstIndex : secondIndex;
        this.entries[entryIndex] = internedEntry;
        return internedEntry;
    }
}

