/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.WritableBuffer;

public class AMQPMirrorMessageFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message createMessage(String to, SimpleString address, SimpleString queue, Object event, String brokerID, Object body, AckReason ackReason) {
        Header header = new Header();
        header.setDurable(Boolean.valueOf(true));
        HashMap<Symbol, Object> annotations = new HashMap<Symbol, Object>();
        annotations.put(AMQPMirrorControllerSource.EVENT_TYPE, event);
        if (ackReason != null && ackReason != AckReason.NORMAL) {
            annotations.put(AMQPMirrorControllerSource.ACK_REASON, ackReason.getVal());
        }
        if (address != null) {
            annotations.put(AMQPMirrorControllerSource.ADDRESS, address.toString());
        }
        if (brokerID != null) {
            annotations.put(AMQPMirrorControllerSource.BROKER_ID, brokerID);
        }
        if (queue != null) {
            annotations.put(AMQPMirrorControllerSource.QUEUE, queue.toString());
        }
        MessageAnnotations messageAnnotations = new MessageAnnotations(annotations);
        AmqpValue sectionBody = body != null ? new AmqpValue(body) : null;
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
        try {
            EncoderImpl encoder = TLSEncode.getEncoder();
            encoder.setByteBuffer((WritableBuffer)new NettyWritable(buffer));
            encoder.writeObject((Object)header);
            encoder.writeObject((Object)messageAnnotations);
            if (sectionBody != null) {
                encoder.writeObject((Object)sectionBody);
            }
            byte[] data = new byte[buffer.writerIndex()];
            buffer.readBytes(data);
            AMQPStandardMessage amqpMessage = new AMQPStandardMessage(0L, data, null);
            amqpMessage.setAddress(to);
            AMQPStandardMessage aMQPStandardMessage = amqpMessage;
            return aMQPStandardMessage;
        }
        finally {
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
            buffer.release();
        }
    }
}

