/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.jgroups.JChannelManager;
import org.apache.activemq.artemis.api.core.jgroups.JChannelWrapper;
import org.apache.activemq.artemis.api.core.jgroups.JGroupsReceiver;
import org.jboss.logging.Logger;
import org.jgroups.BytesMessage;
import org.jgroups.JChannel;
import org.jgroups.Message;

public abstract class JGroupsBroadcastEndpoint
implements BroadcastEndpoint {
    private static final Logger logger = Logger.getLogger(JGroupsBroadcastEndpoint.class);
    private final String channelName;
    private boolean clientOpened;
    private boolean broadcastOpened;
    private JChannelWrapper channel;
    private JGroupsReceiver receiver;
    private JChannelManager manager;

    public JGroupsBroadcastEndpoint(JChannelManager manager, String channelName) {
        this.manager = manager;
        this.channelName = channelName;
    }

    @Override
    public void broadcast(byte[] data) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Broadcasting: BroadCastOpened=" + this.broadcastOpened + ", channelOPen=" + this.channel.getChannel().isOpen()));
        }
        if (this.broadcastOpened) {
            BytesMessage msg = new BytesMessage();
            msg.setArray(data);
            this.channel.send((Message)msg);
        }
    }

    @Override
    public byte[] receiveBroadcast() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Receiving Broadcast: clientOpened=" + this.clientOpened + ", channelOPen=" + this.channel.getChannel().isOpen()));
        }
        if (this.clientOpened) {
            return this.receiver.receiveBroadcast();
        }
        return null;
    }

    @Override
    public byte[] receiveBroadcast(long time, TimeUnit unit) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Receiving Broadcast2: clientOpened=" + this.clientOpened + ", channelOPen=" + this.channel.getChannel().isOpen()));
        }
        if (this.clientOpened) {
            return this.receiver.receiveBroadcast(time, unit);
        }
        return null;
    }

    @Override
    public synchronized void openClient() throws Exception {
        if (this.clientOpened) {
            return;
        }
        this.internalOpen();
        this.receiver = new JGroupsReceiver();
        this.channel.addReceiver(this.receiver);
        this.clientOpened = true;
    }

    @Override
    public synchronized void openBroadcaster() throws Exception {
        if (this.broadcastOpened) {
            return;
        }
        this.internalOpen();
        this.broadcastOpened = true;
    }

    public abstract JChannel createChannel() throws Exception;

    public JGroupsBroadcastEndpoint initChannel() throws Exception {
        this.channel = this.manager.getJChannel(this.channelName, this);
        return this;
    }

    protected void internalOpen() throws Exception {
        this.channel.connect();
    }

    @Override
    public synchronized void close(boolean isBroadcast) throws Exception {
        if (isBroadcast) {
            this.broadcastOpened = false;
        } else {
            this.channel.removeReceiver(this.receiver);
            this.clientOpened = false;
        }
        this.internalCloseChannel(this.channel);
    }

    protected synchronized void internalCloseChannel(JChannelWrapper channel) {
        channel.close(true);
    }
}

